

package org.gcube.accounting.ut;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * A class modeling the update status of the usage tracker for a given
 * infrastructure (a.k.a. resource owner)
 * 
 */

@XmlRootElement
public class UpdateInfo {

	private String dci;
	private Long timestamp;

	public UpdateInfo() {
	}

	public UpdateInfo(String dci, Long timestamp) {
		this.dci = dci;
		this.timestamp = timestamp;
	}

	/**
	 * Return a reference to the infrastructure
	 * 
	 * @return
	 */
	public String getDci() {
		return dci;
	}

	/**
	 * Set a reference to the infrastructure
	 */
	public void setDci(String dci) {
		this.dci = dci;
	}

	/**
	 * Return the last time a usage record has been published for the
	 * infrastructure
	 * 
	 * @return
	 */
	public Long getTimestamp() {
		return timestamp;
	}

	/**
	 * Set the last time a usage record has been published for the
	 * infrastructure
	 * 
	 * @return
	 */
	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

}
