

package org.gcube.accounting.datamodel;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.gcube.accounting.datamodel.serialization.PropertiesAdapter;

/**
 * 
 * This object represent an user-id membership
 * 
 */

@XmlRootElement(name = "membership")
public class Membership {

	/**
	 * The user identity
	 */
	private String identity;
	
	/**
	 * The position of the user in the organisation hierarchy
	 */
	private Collection<String> hierarchy;
	
	/**
	 * Arbitrary user properties (multi-value)
	 */
	private Map<String, List<String>> properties;

	public Membership() {
		super();
	}
	
	public Membership(String identity, Collection<String> hierarchy,
			Map<String, List<String>> properties) {
		this();
		this.identity = identity;
		this.hierarchy = hierarchy;
		this.properties = properties;
	}

	/**
	 * 
	 * @return Current user's identity
	 */
	@XmlAttribute
	public String getIdentity() {
		return identity;
	}

	/**
	 * 
	 * @param identity
	 *            Identity to set
	 */
	public void setIdentity(String identity) {
		this.identity = identity;
	}

	/**
	 * 
	 * @return Current user's hierarchy
	 */
	@XmlElementWrapper(name = "hierarchy")
	@XmlElement(name = "branch")
	public Collection<String> getHierarchy() {
		return hierarchy;
	}

	/**
	 * 
	 * @param hierarchy
	 *            Hierarchy to set
	 */
	public void setHierarchy(Collection<String> hierarchy) {
		this.hierarchy = hierarchy;
	}

	/**
	 * Since java.util.Map is an unmappable class, an equivalent mappable class
	 * {@link org.AdapterFilterList.mab.membership.datamodel.serialization.AdaptedList
	 * AdaptedMap} is created. During marshal/unmarshal operations the instance
	 * of Map is treated as an instance of AdaptedMap.
	 * 
	 * @return Current user's properties
	 */
	@XmlJavaTypeAdapter(PropertiesAdapter.class)
	public Map<String, List<String>> getProperties() {
		if (properties == null)
			properties = new HashMap<String, List<String>>();
		return properties;
	}

	/**
	 * 
	 * @param properties
	 *            Properties to set
	 */
	public void setProperties(Map<String, List<String>> properties) {
		this.properties = properties;
	}

}
