package org.gcube.accounting.datamodel.reports.storagestatus;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.accounting.datamodel.reports.ReportFilter;

@XmlRootElement(name = "storageStatusReportFilter")
public enum StorageStatusReportFilter implements ReportFilter{

	STORAGE_STATUS_FILTER_DATATYPE("dataType"),
	STORAGE_STATUS_FILTER_PROVIDERID("providerId");

	@XmlAttribute
	private String name;

	private StorageStatusReportFilter(String name) {
		this.name = name;
	}

	public String toName() {
		return this.name;
	}

	public StorageStatusReportFilter toEnum(String text) {
		if (text != null) {
			for (StorageStatusReportFilter b : StorageStatusReportFilter.values()) {
				if (text.equalsIgnoreCase(b.toName())) {
					return b;
				}
			}
		}
		return null;
	}

}
