/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security.authn;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;
import org.gcube.accounting.security.authn.AuthenticationManager;

public class FileAuthenticationManager
implements AuthenticationManager {
    private static Logger logger = Logger.getLogger(FileAuthenticationManager.class);
    private PropertiesConfiguration file;
    private String realm;

    public FileAuthenticationManager(String file) throws ConfigurationException {
        this(new PropertiesConfiguration(file));
    }

    public FileAuthenticationManager(PropertiesConfiguration file) {
        this.file = file;
        FileChangedReloadingStrategy fcrs = new FileChangedReloadingStrategy();
        file.setReloadingStrategy((ReloadingStrategy)fcrs);
    }

    private String getUserPassword(String username) {
        return this.file.getString(username);
    }

    @Override
    public boolean authenticate(String username, String password) {
        String pwd = this.getUserPassword(username);
        if (pwd == null) {
            logger.info((Object)("unknown user " + username));
            return false;
        }
        if (!pwd.equals(password)) {
            logger.info((Object)("bad password provided for user " + username));
            return false;
        }
        logger.info((Object)("user " + username + " authenticated!"));
        return true;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }
}

