/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;

public interface AccountingPersistenceBackendQuery {
    public static final int KEY_VALUES_LIMIT = 25;

    public static String getScopeToQuery() {
        String scope = (String)AccountingPersistenceQueryFactory.getForcedQueryScope().get();
        if (scope == null) {
            scope = BasicUsageRecord.getContextFromToken();
        }
        return scope;
    }

    public void prepareConnection(AccountingPersistenceBackendQueryConfiguration var1) throws Exception;

    public void setRequestedRecords(Class<? extends AggregatedRecord<?, ?>> var1);

    public void setTemporalConstraint(TemporalConstraint var1);

    public void setContexts(Set<String> var1);

    public void setFilters(Collection<? extends Filter> var1);

    public SortedMap<Calendar, Info> getTimeSeries() throws Exception;

    public SortedMap<Filter, SortedMap<Calendar, Info>> getContextTimeSeries() throws Exception;

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(String var1, String var2, Integer var3) throws Exception;

    public void close() throws Exception;

    public SortedSet<NumberedFilter> getFilterValues(String var1) throws Exception;

    public SortedSet<NumberedFilter> getFilterValues(String var1, Integer var2) throws Exception;

    public Record getRecord(String var1, String var2) throws Exception;

    public SortedMap<Filter, SortedMap<Calendar, Info>> getSpaceTimeSeries(Set<String> var1) throws Exception;

    public List<UsageValue> getUsageValueQuotaTotal(List<UsageValue> var1) throws Exception;

    public boolean isConnectionActive() throws Exception;
}

