/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.accounting.analytics.exception.NoAvailableScopeException;
import org.gcube.accounting.analytics.exception.NoUsableAccountingPersistenceQueryFound;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccountingPersistenceBackendQueryFactory {
    private static Logger logger = LoggerFactory.getLogger(AccountingPersistenceBackendQueryFactory.class);
    private static Map<String, AccountingPersistenceBackendQuery> accountingPersistenceQueries = new HashMap<String, AccountingPersistenceBackendQuery>();

    public static synchronized AccountingPersistenceBackendQuery getInstance() throws NoAvailableScopeException, NoUsableAccountingPersistenceQueryFound {
        String scope = ScopeProvider.instance.get();
        if (scope == null) {
            throw new NoAvailableScopeException();
        }
        AccountingPersistenceBackendQuery accountingPersistenceQuery = accountingPersistenceQueries.get(scope);
        if (accountingPersistenceQuery == null) {
            try {
                ServiceLoader<AccountingPersistenceBackendQuery> serviceLoader = ServiceLoader.load(AccountingPersistenceBackendQuery.class);
                for (AccountingPersistenceBackendQuery found : serviceLoader) {
                    Class<?> foundClass = null;
                    try {
                        foundClass = found.getClass();
                        String foundClassName = foundClass.getSimpleName();
                        logger.debug("Testing {}", (Object)foundClassName);
                        AccountingPersistenceBackendQueryConfiguration configuration = new AccountingPersistenceBackendQueryConfiguration(foundClass);
                        found.prepareConnection(configuration);
                        accountingPersistenceQuery = found;
                        break;
                    }
                    catch (Exception e) {
                        logger.error(String.format("%s not initialized correctly. It will not be used", foundClass.getSimpleName()));
                    }
                }
            }
            catch (Exception e) {
                logger.error(String.format("service loader or  not initialized correctly.", new Object[0]));
                throw new NoUsableAccountingPersistenceQueryFound(e.getLocalizedMessage());
            }
            if (accountingPersistenceQuery == null) {
                logger.error(String.format("accountingPersistenceQuery null", new Object[0]));
                throw new NoUsableAccountingPersistenceQueryFound();
            }
            accountingPersistenceQueries.put(scope, accountingPersistenceQuery);
        }
        return accountingPersistenceQuery;
    }

    protected AccountingPersistenceBackendQueryFactory() {
    }
}

