/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccountingPersistenceBackendQuery {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceBackendQuery.class);

    protected abstract void prepareConnection(AccountingPersistenceBackendQueryConfiguration var1) throws Exception;

    protected abstract Map<Calendar, Info> reallyQuery(Class<? extends AggregatedUsageRecord> var1, TemporalConstraint var2, List<Filter> var3) throws Exception;

    public Map<Calendar, Info> query(Class<? extends AggregatedUsageRecord> usageRecordType, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        logger.trace("Request query: UsageRecordType={}, {}={}, {}s={}", new Object[]{usageRecordType.newInstance().getUsageRecordType(), TemporalConstraint.class.getSimpleName(), temporalConstraint.toString(), Filter.class.getSimpleName(), filters});
        return this.reallyQuery(usageRecordType, temporalConstraint, filters);
    }

    public abstract Set<String> getKeys(Class<? extends AggregatedUsageRecord> var1) throws Exception;

    public abstract Set<String> getPossibleValuesForKey(Class<? extends AggregatedUsageRecord> var1, String var2) throws Exception;

    public abstract void close() throws Exception;
}

