/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.functions;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.Expression;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class DateFunctions {
    public static Expression clockMillis() {
        return Expression.x("CLOCK_MILLIS()");
    }

    public static Expression clockStr(String format) {
        if (format == null || format.isEmpty()) {
            return Expression.x("CLOCK_STR()");
        }
        return Expression.x("CLOCK_STR(\"" + format + "\")");
    }

    public static Expression dateAddMillis(Expression expression, int n, DatePart part) {
        return Expression.x("DATE_ADD_MILLIS(" + expression.toString() + ", " + n + ", \"" + (Object)((Object)part) + "\")");
    }

    public static Expression dateAddMillis(String expression, int n, DatePart part) {
        return DateFunctions.dateAddMillis(Expression.x(expression), n, part);
    }

    public static Expression dateAddStr(Expression expression, int n, DatePart part) {
        return Expression.x("DATE_ADD_STR(" + expression.toString() + ", " + n + ", \"" + (Object)((Object)part) + "\")");
    }

    public static Expression dateAddStr(String expression, int n, DatePart part) {
        return DateFunctions.dateAddStr(Expression.x(expression), n, part);
    }

    public static Expression dateDiffMillis(Expression expression1, Expression expression2, DatePart part) {
        return Expression.x("DATE_DIFF_MILLIS(" + expression1.toString() + ", " + expression2.toString() + ", \"" + part.toString() + "\")");
    }

    public static Expression dateDiffMillis(String expression1, String expression2, DatePart part) {
        return DateFunctions.dateDiffMillis(Expression.x(expression1), Expression.x(expression2), part);
    }

    public static Expression dateDiffStr(Expression expression1, Expression expression2, DatePart part) {
        return Expression.x("DATE_DIFF_STR(" + expression1.toString() + ", " + expression2.toString() + ", \"" + part.toString() + "\")");
    }

    public static Expression dateDiffStr(String expression1, String expression2, DatePart part) {
        return DateFunctions.dateDiffStr(Expression.x(expression1), Expression.x(expression2), part);
    }

    public static Expression datePartMillis(Expression expression, DatePartExt part) {
        return Expression.x("DATE_PART_MILLIS(" + expression.toString() + ", \"" + part.toString() + "\")");
    }

    public static Expression datePartMillis(String expression, DatePartExt part) {
        return DateFunctions.datePartMillis(Expression.x(expression), part);
    }

    public static Expression datePartStr(Expression expression, DatePartExt part) {
        return Expression.x("DATE_PART_STR(" + expression.toString() + ", \"" + part.toString() + "\")");
    }

    public static Expression datePartStr(String expression, DatePartExt part) {
        return DateFunctions.datePartStr(Expression.x(expression), part);
    }

    public static Expression dateTruncMillis(Expression expression, DatePart part) {
        return Expression.x("DATE_TRUNC_MILLIS(" + expression.toString() + ", \"" + part.toString() + "\")");
    }

    public static Expression dateTruncMillis(String expression, DatePart part) {
        return DateFunctions.dateTruncMillis(Expression.x(expression), part);
    }

    public static Expression dateTruncStr(Expression expression, DatePart part) {
        return Expression.x("DATE_TRUNC_STR(" + expression.toString() + ", \"" + part.toString() + "\")");
    }

    public static Expression dateTruncStr(String expression, DatePart part) {
        return DateFunctions.dateTruncStr(Expression.x(expression), part);
    }

    public static Expression millis(Expression expression) {
        return Expression.x("MILLIS(" + expression.toString() + ")");
    }

    public static Expression millis(String expression) {
        return DateFunctions.millis(Expression.x(expression));
    }

    public static Expression strToMillis(Expression expression) {
        return Expression.x("STR_TO_MILLIS(" + expression.toString() + ")");
    }

    public static Expression strToMillis(String expression) {
        return DateFunctions.strToMillis(Expression.x(expression));
    }

    public static Expression millisToStr(Expression expression, String format) {
        if (format == null || format.isEmpty()) {
            return Expression.x("MILLIS_TO_STR(" + expression.toString() + ")");
        }
        return Expression.x("MILLIS_TO_STR(" + expression.toString() + ", \"" + format + "\")");
    }

    public static Expression millisToStr(String expression, String format) {
        return DateFunctions.millisToStr(Expression.x(expression), format);
    }

    public static Expression millisToUtc(Expression expression, String format) {
        if (format == null || format.isEmpty()) {
            return Expression.x("MILLIS_TO_UTC(" + expression.toString() + ")");
        }
        return Expression.x("MILLIS_TO_UTC(" + expression.toString() + ", \"" + format + "\")");
    }

    public static Expression millisToUtc(String expression, String format) {
        return DateFunctions.millisToUtc(Expression.x(expression), format);
    }

    public static Expression millisToZone(Expression expression, String timeZoneName, String format) {
        if (format == null || format.isEmpty()) {
            return Expression.x("MILLIS_TO_ZONE(" + expression.toString() + ", \"" + timeZoneName + "\")");
        }
        return Expression.x("MILLIS_TO_ZONE(" + expression.toString() + ", \"" + timeZoneName + "\"" + ", \"" + format + "\")");
    }

    public static Expression millisToZone(String expression, String timeZoneName, String format) {
        return DateFunctions.millisToZone(Expression.x(expression), timeZoneName, format);
    }

    public static Expression nowMillis() {
        return Expression.x("NOW_MILLIS()");
    }

    public static Expression nowStr(String format) {
        if (format == null || format.isEmpty()) {
            return Expression.x("NOW_STR()");
        }
        return Expression.x("NOW_STR(\"" + format + "\")");
    }

    public static Expression strToUtc(Expression expression) {
        return Expression.x("STR_TO_UTC(" + expression.toString() + ")");
    }

    public static Expression strToUtc(String expression) {
        return DateFunctions.strToUtc(Expression.x(expression));
    }

    public static Expression strToZoneName(Expression expression, String zoneName) {
        return Expression.x("STR_TO_ZONE_NAME(" + expression.toString() + ", \"" + zoneName + "\")");
    }

    public static Expression strToZoneName(String expression, String zoneName) {
        return DateFunctions.strToZoneName(Expression.x(expression), zoneName);
    }

    public static enum DatePartExt {
        millenium,
        century,
        decade,
        year,
        quarter,
        month,
        week,
        day,
        hour,
        minute,
        second,
        millisecond,
        day_of_year,
        day_of_week,
        iso_week,
        iso_year,
        iso_dow,
        timezone,
        timezone_hour,
        timezone_minute;

    }

    public static enum DatePart {
        millenium,
        century,
        decade,
        year,
        quarter,
        month,
        week,
        day,
        hour,
        minute,
        second,
        millisecond;

    }
}

