/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.query.SearchQuery;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class NumericRangeQuery
extends SearchQuery {
    public static final double BOOST = 1.0;
    private static final boolean INCLUSIVE_MIN = true;
    private static final boolean INCLUSIVE_MAX = false;
    private final double min;
    private final double max;
    private final boolean inclusiveMin;
    private final boolean inclusiveMax;
    private final String field;
    private final double boost;

    protected NumericRangeQuery(Builder builder) {
        super(builder);
        this.min = builder.min;
        this.max = builder.max;
        this.inclusiveMin = builder.inclusiveMin;
        this.inclusiveMax = builder.inclusiveMax;
        this.field = builder.field;
        this.boost = builder.boost;
    }

    public static Builder on(String index) {
        return new Builder(index);
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public boolean inclusiveMin() {
        return this.inclusiveMin;
    }

    public boolean inclusiveMax() {
        return this.inclusiveMax;
    }

    public String field() {
        return this.field;
    }

    @Override
    public double boost() {
        return this.boost;
    }

    @Override
    public JsonObject queryJson() {
        return JsonObject.create().put("min", this.min).put("max", this.max).put("inclusiveMin", this.inclusiveMin).put("inclusiveMax", this.inclusiveMax).put("field", this.field).put("boost", this.boost);
    }

    public static class Builder
    extends SearchQuery.Builder {
        public double boost = 1.0;
        private double min;
        private double max;
        private boolean inclusiveMin = true;
        private boolean inclusiveMax = false;
        private String field;

        protected Builder(String index) {
            super(index);
        }

        @Override
        public NumericRangeQuery build() {
            return new NumericRangeQuery(this);
        }

        @Override
        public Builder boost(double boost) {
            this.boost = boost;
            return this;
        }

        public Builder min(double min) {
            this.min = min;
            return this;
        }

        public Builder max(double max) {
            this.max = max;
            return this;
        }

        public Builder inclusiveMin(boolean inclusiveMin) {
            this.inclusiveMin = inclusiveMin;
            return this;
        }

        public Builder inclusiveMax(boolean inclusiveMax) {
            this.inclusiveMax = inclusiveMax;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }
    }
}

