/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.util;

import com.couchbase.client.deps.io.netty.buffer.ByteBufProcessor;

public class ClosingPositionBufProcessor
implements ByteBufProcessor {
    private int openCount = 0;
    private final char openingChar;
    private final char closingChar;
    private final boolean detectJsonString;
    private byte lastByte = 0;
    private byte beforeLastByte = 0;
    private boolean inString = false;

    public ClosingPositionBufProcessor(char openingChar, char closingChar) {
        this(openingChar, closingChar, false);
    }

    public ClosingPositionBufProcessor(char openingChar, char closingChar, boolean detectJsonString) {
        if (openingChar == closingChar) {
            throw new IllegalArgumentException("only asymmetric section enclosing characters are supported");
        }
        this.openingChar = openingChar;
        this.closingChar = closingChar;
        this.detectJsonString = detectJsonString;
    }

    @Override
    public boolean process(byte current) throws Exception {
        if (this.detectJsonString && this.openCount > 0 && this.isEscaped(current)) {
            return true;
        }
        if (current == this.openingChar) {
            ++this.openCount;
        } else if (current == this.closingChar && this.openCount > 0) {
            --this.openCount;
            if (this.openCount == 0) {
                return false;
            }
        }
        return true;
    }

    private boolean isEscaped(byte nextByte) {
        boolean result = false;
        if (this.inString) {
            if (nextByte == 34) {
                boolean escaped;
                this.inString = escaped = this.lastByte == 92 && this.beforeLastByte != 92;
            }
            result = true;
        } else if (nextByte == 34) {
            this.inString = true;
            result = true;
        }
        this.beforeLastByte = this.lastByte;
        this.lastByte = nextByte;
        return result;
    }
}

