/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.view.AsyncViewRow;
import rx.Observable;

public class DefaultAsyncViewRow
implements AsyncViewRow {
    private final String id;
    private final Object key;
    private final Object value;
    private final AsyncBucket bucket;
    private final Document<?> document;

    public DefaultAsyncViewRow(AsyncBucket bucket, String id, Object key, Object value, Document<?> document) {
        this.bucket = bucket;
        this.id = id;
        this.key = key;
        this.value = value;
        this.document = document;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public Observable<JsonDocument> document() {
        return this.document(JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> document(Class<D> target) {
        if (this.document != null) {
            return Observable.just(this.document);
        }
        if (this.id == null) {
            return Observable.error(new UnsupportedOperationException("Document cannot be loaded, id is null."));
        }
        return this.bucket.get(this.id, target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultViewRow{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", key=").append(this.key);
        sb.append(", value=").append(this.value);
        sb.append(", document=").append(this.document);
        sb.append('}');
        return sb.toString();
    }
}

