/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Filters;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.TotalFilters;
import org.gcube.accounting.analytics.exception.DuplicatedKeyFilterException;
import org.gcube.accounting.analytics.exception.ValueException;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingPersistenceQueryCouchBase
implements AccountingPersistenceBackendQuery {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceQueryCouchBase.class);
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String BUCKET_STORAGE_NAME_PROPERTY_KEY = "AggregatedStorageUsageRecord";
    public static final String BUCKET_SERVICE_NAME_PROPERTY_KEY = "AggregatedServiceUsageRecord";
    public static final String BUCKET_PORTLET_NAME_PROPERTY_KEY = "AggregatedPortletUsageRecord";
    public static final String BUCKET_JOB_NAME_PROPERTY_KEY = "AggregatedJobUsageRecord";
    public static final String BUCKET_TASK_NAME_PROPERTY_KEY = "AggregatedTaskUsageRecord";
    public static final String SEPARATOR_DESIGN_DOC = "_";
    public static final long ENV_TIME_OUT = 180000L;
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().maxRequestLifetime(180000L).queryTimeout(180000L).build();
    protected Cluster cluster;
    protected Bucket bucketStorage;
    protected String bucketNameStorage;
    protected Bucket bucketService;
    protected String bucketNameService;
    protected Bucket bucketPortlet;
    protected String bucketNamePortlet;
    protected Bucket bucketJob;
    protected String bucketNameJob;
    protected Bucket bucketTask;
    protected String bucketNameTask;
    private Map<String, Bucket> connectionMap;
    protected static final String MAP_REDUCE__DESIGN = "";
    protected static final String MAP_REDUCE_ALL = "all";
    protected static final String KEYS_SEPARATOR = "__";

    public void prepareConnection(AccountingPersistenceBackendQueryConfiguration configuration) throws Exception {
        String url = configuration.getProperty(URL_PROPERTY_KEY);
        String password = configuration.getProperty(PASSWORD_PROPERTY_KEY);
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)ENV, (String[])new String[]{url});
        logger.trace("env" + ENV.toString());
        this.bucketNameStorage = configuration.getProperty(BUCKET_STORAGE_NAME_PROPERTY_KEY);
        this.bucketNameService = configuration.getProperty(BUCKET_SERVICE_NAME_PROPERTY_KEY);
        this.bucketNameJob = configuration.getProperty(BUCKET_JOB_NAME_PROPERTY_KEY);
        this.bucketNamePortlet = configuration.getProperty(BUCKET_PORTLET_NAME_PROPERTY_KEY);
        this.bucketNameTask = configuration.getProperty(BUCKET_TASK_NAME_PROPERTY_KEY);
        this.connectionMap = new HashMap<String, Bucket>();
        this.bucketStorage = this.cluster.openBucket(this.bucketNameStorage, password);
        this.connectionMap.put(BUCKET_STORAGE_NAME_PROPERTY_KEY, this.bucketStorage);
        this.bucketService = this.cluster.openBucket(this.bucketNameService, password);
        this.connectionMap.put(BUCKET_SERVICE_NAME_PROPERTY_KEY, this.bucketService);
        this.bucketJob = this.cluster.openBucket(this.bucketNameJob, password);
        this.connectionMap.put(BUCKET_JOB_NAME_PROPERTY_KEY, this.bucketJob);
        this.bucketPortlet = this.cluster.openBucket(this.bucketNamePortlet, password);
        this.connectionMap.put(BUCKET_PORTLET_NAME_PROPERTY_KEY, this.bucketPortlet);
        this.bucketTask = this.cluster.openBucket(this.bucketNameTask, password);
        this.connectionMap.put(BUCKET_TASK_NAME_PROPERTY_KEY, this.bucketTask);
        logger.trace("Open cluster Service Bucket Url:" + url + " Pwd:" + configuration.getProperty(PASSWORD_PROPERTY_KEY) + " BucketName " + configuration.getProperty(BUCKET_SERVICE_NAME_PROPERTY_KEY));
    }

    public void close() throws Exception {
        this.cluster.disconnect();
    }

    protected Calendar getCalendar(JSONObject obj, TemporalConstraint.AggregationMode aggregationMode) throws NumberFormatException, JSONException {
        long millis;
        if (obj.has("startTime")) {
            millis = new Long(obj.getString("startTime"));
            logger.trace("The result {} was from an aggregated record. Using {}", (Object)obj.toString(), (Object)"startTime");
        } else {
            millis = new Long(obj.getString("creationTime"));
            logger.trace("The result {} was from single record. Using {}", (Object)obj.toString(), (Object)"creationTime");
        }
        Calendar calendar = TemporalConstraint.getAlignedCalendar((long)millis, (TemporalConstraint.AggregationMode)aggregationMode);
        logger.trace("{} has been aligned to {}", (Object)millis, (Object)calendar.getTimeInMillis());
        return calendar;
    }

    protected Map<Calendar, Info> selectQuery(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        String recordType = clz.newInstance().getRecordType();
        Expression expression = Expression.x((String)"scope").eq(Expression.s((String[])new String[]{currentScope}));
        expression = expression.and(Expression.x((String)"recordType").eq(Expression.s((String[])new String[]{recordType})));
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        expression = expression.and(Expression.x((String)"startTime").gt(startTime).or(Expression.x((String)"creationTime").gt(startTime)));
        long endTime = temporalConstraint.getAlignedEndTime().getTimeInMillis();
        expression = expression.and(Expression.x((String)"endTime").lt(endTime)).or(Expression.x((String)"creationTime").lt(endTime));
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        if (filters != null) {
            for (Filter filter : filters) {
                expression = expression.and(Expression.x((String)filter.getKey()).eq(Expression.s((String[])new String[]{filter.getValue()})));
            }
        }
        GroupByPath groupByPath = Select.select((String[])new String[]{"*"}).from(this.connectionMap.get(clz.getSimpleName()).name()).where(expression);
        HashMap<Calendar, Info> map = new HashMap<Calendar, Info>();
        N1qlQueryResult result = this.connectionMap.get(clz.getSimpleName()).query((Statement)groupByPath);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), (Object)result.errors());
            return map;
        }
        List rows = result.allRows();
        for (N1qlQueryRow row : rows) {
            try {
                logger.trace("Row : {}", (Object)row.toString());
                JsonObject jsonObject = row.value().getObject(clz.getSimpleName());
                logger.trace("JsonObject : {}", (Object)row.toString());
                String recordString = jsonObject.toMap().toString();
                logger.trace("Record String : {}", (Object)recordString);
                Record record = RecordUtility.getRecord((String)recordString);
                JSONObject obj = new JSONObject(jsonObject.toString());
                Calendar calendar = this.getCalendar(obj, aggregationMode);
                if (map.containsKey(calendar)) {
                    Info info = (Info)map.get(calendar);
                    JSONObject value = info.getValue();
                    jsonObject.toMap();
                } else {
                    map.put(calendar, new Info(calendar, obj));
                }
            }
            catch (Exception e) {
                logger.warn("Unable to eleborate result for {}", (Object)row.toString());
            }
            logger.trace("\n\n\n");
        }
        return map;
    }

    protected Calendar getCalendarFromArray(JsonArray array) throws JSONException {
        boolean startFound = false;
        Calendar calendar = Calendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        int count = 0;
        TemporalConstraint.CalendarEnum[] calendarValues = TemporalConstraint.CalendarEnum.values();
        for (int i = 0; i < array.size(); ++i) {
            try {
                int value = array.getInt(i);
                int calendarValue = calendarValues[count].getCalendarValue();
                if (calendarValue == 2) {
                    --value;
                }
                calendar.set(calendarValue, value);
                ++count;
                startFound = true;
                continue;
            }
            catch (Exception e) {
                if (startFound) break;
            }
        }
        for (int j = count; j < calendarValues.length; ++j) {
            if (calendarValues[j].getCalendarValue() == 5) {
                calendar.set(calendarValues[j].getCalendarValue(), 1);
                continue;
            }
            calendar.set(calendarValues[j].getCalendarValue(), 0);
        }
        return calendar;
    }

    protected JsonArray getRangeKey(long time, TemporalConstraint.AggregationMode aggregationMode, boolean wildCard, boolean endKey) throws JSONException {
        JsonArray array = JsonArray.create();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        TemporalConstraint.CalendarEnum[] values = TemporalConstraint.CalendarEnum.values();
        if (endKey) {
            calendar.add(values[aggregationMode.ordinal()].getCalendarValue(), 1);
        }
        for (int i = 0; i <= aggregationMode.ordinal(); ++i) {
            int value = calendar.get(values[i].getCalendarValue());
            if (values[i].getCalendarValue() == 2) {
                ++value;
            }
            array.add(value);
        }
        if (wildCard) {
            array.add("{}");
        }
        return array;
    }

    protected String getDesignDocId(Class<? extends AggregatedRecord<?, ?>> recordClass) throws InstantiationException, IllegalAccessException {
        String getDesigndocid = String.format("%s%s", MAP_REDUCE__DESIGN, recordClass.newInstance().getRecordType());
        return String.format("%s%s", MAP_REDUCE__DESIGN, recordClass.newInstance().getRecordType());
    }

    protected String getDesignDocIdSpecific(Class<? extends AggregatedRecord<?, ?>> recordClass, Collection<String> keys) throws InstantiationException, IllegalAccessException {
        String getDesigndocId = String.format("%s%s", MAP_REDUCE__DESIGN, recordClass.newInstance().getRecordType());
        String specific = MAP_REDUCE_ALL;
        if (!keys.isEmpty()) {
            specific = keys.iterator().next();
        }
        String getDesigndocIdSpecific = getDesigndocId + SEPARATOR_DESIGN_DOC + specific;
        logger.debug("use a designDocIDSpecific:{}", (Object)getDesigndocIdSpecific);
        return getDesigndocIdSpecific;
    }

    public static String getMapReduceFunctionName(Collection<String> collection) {
        String reduceFunction = MAP_REDUCE_ALL;
        if (!collection.isEmpty()) {
            reduceFunction = null;
            for (String property : collection) {
                if (reduceFunction == null) {
                    reduceFunction = property;
                    continue;
                }
                reduceFunction = reduceFunction + KEYS_SEPARATOR + property;
            }
        }
        return reduceFunction;
    }

    protected SortedMap<Calendar, Info> mapReduceQuery(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = ScopeProvider.instance.get();
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        JsonArray endKey = JsonArray.create();
        endKey.add(currentScope);
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
        TreeSet<String> keys = new TreeSet<String>();
        if (filters != null && filters.size() != 0) {
            Collections.sort(filters, new Comparator<Filter>(){

                @Override
                public int compare(Filter filter1, Filter filter2) {
                    int result = filter1.getKey().compareTo(filter2.getKey());
                    return result;
                }
            });
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        startKey.add(filterValue);
                        endKey.add(filterValue);
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        int groupLevel = scopeDateGroupLevel = aggregationMode.ordinal() + 1 + 1;
        if (filters != null) {
            groupLevel += keys.size();
        }
        String designDocId = this.getDesignDocId(clz);
        String designDocIdNew = this.getDesignDocIdSpecific(clz, keys);
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        String viewName = AccountingPersistenceQueryCouchBase.getMapReduceFunctionName(keys);
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        TreeMap<Calendar, Info> infos = new TreeMap<Calendar, Info>();
        try {
            viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        for (ViewRow row : viewResult) {
            JsonArray array = (JsonArray)row.key();
            Calendar calendar = this.getCalendarFromArray(array);
            JsonObject value = (JsonObject)row.value();
            JSONObject obj = new JSONObject(value.toString());
            Info info = new Info(calendar, obj);
            infos.put(calendar, info);
        }
        if (infos.isEmpty()) {
            query = ViewQuery.from((String)designDocId, (String)viewName);
            query.groupLevel(groupLevel);
            query.descending(false);
            try {
                viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage());
                throw e;
            }
            ViewRow row = (ViewRow)viewResult.allRows().get(0);
            JsonArray array = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
            Calendar calendar = this.getCalendarFromArray(array);
            JsonObject value = (JsonObject)row.value();
            JSONObject objJson = new JSONObject(value.toString());
            JSONObject objJsontemplate = new JSONObject();
            Iterator iterateJson = objJson.keys();
            while (iterateJson.hasNext()) {
                String key = (String)iterateJson.next();
                objJsontemplate.put(key, 0);
            }
            Info info = new Info(calendar, objJsontemplate);
            infos.put(calendar, info);
        }
        return infos;
    }

    public SortedMap<Calendar, Info> getTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters);
        return map;
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String topKey, String orderingProperty) throws Exception {
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                int result = -o1.compareTo(o2);
                if (result == 0) {
                    result = o1.compareTo((Filter)o2);
                }
                return result;
            }
        };
        TreeMap<NumberedFilter, SortedMap<Calendar, Info>> ret = new TreeMap<NumberedFilter, SortedMap<Calendar, Info>>(comparator);
        SortedSet<NumberedFilter> top = this.getNextPossibleValues(clz, temporalConstraint, filters, topKey, orderingProperty);
        for (NumberedFilter nf : top) {
            filters.add((Filter)nf);
            SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters);
            ret.put(nf, map);
            filters.remove(nf);
        }
        return ret;
    }

    protected String getQualifiedProperty(String property) {
        return property;
    }

    protected String getSpecializedProperty(Class<? extends AggregatedRecord<?, ?>> clz, String property) {
        return String.format("%s.%s", this.connectionMap.get(clz.getSimpleName()).name(), property);
    }

    public SortedSet<NumberedFilter> getNextPossibleValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, String orderingProperty) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        String recordType = clz.newInstance().getRecordType();
        if (orderingProperty == null) {
            orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        }
        ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
        selectExpressions.add(Expression.x((String)("SUM(CASE WHEN " + this.getSpecializedProperty(clz, orderingProperty) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, orderingProperty) + " ELSE 1 END )")).as(orderingProperty));
        selectExpressions.add(Expression.x((String)("(CASE WHEN " + this.getSpecializedProperty(clz, key) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, key) + " ELSE 'UNKNOWN' END )")).as(key));
        Expression whereExpression = Expression.x((String)this.getSpecializedProperty(clz, "scope")).eq(Expression.s((String[])new String[]{currentScope}));
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "startTime")).gt(startTime));
        long endTime = temporalConstraint.getEndTime();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "endTime")).lt(endTime));
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
        TreeSet<String> keys = new TreeSet<String>();
        if (filters != null && filters.size() != 0) {
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, filterKey)).eq(Expression.s((String[])new String[]{filterValue})));
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        Expression[] selectExpressionArray = new Expression[selectExpressions.size()];
        selectExpressions.toArray(selectExpressionArray);
        Sort sort = Sort.desc((String)orderingProperty);
        LimitPath path = Select.select((Expression[])selectExpressionArray).from(this.connectionMap.get(clz.getSimpleName()).name()).where(whereExpression).groupBy(new String[]{key}).orderBy(new Sort[]{sort});
        logger.debug("Query for top" + path.toString());
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                int compareResult = -o1.compareTo(o2);
                if (compareResult == 0) {
                    compareResult = 1;
                }
                return compareResult;
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        N1qlQueryResult result = this.connectionMap.get(clz.getSimpleName()).query((Statement)path);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), (Object)result.errors());
            throw new Exception("Query Failed :\n" + result.errors());
        }
        List rows = result.allRows();
        for (N1qlQueryRow row : rows) {
            try {
                JsonObject jsonObject = row.value();
                String value = jsonObject.getString(key);
                Number n = jsonObject.getDouble(orderingProperty);
                if (n == null) {
                    n = 0;
                }
                logger.trace("pre:{}, key:{}, value:{}, n:{},orderingProperty:{}", new Object[]{jsonObject.toString(), key, value, n, orderingProperty});
                NumberedFilter numberedFilter = new NumberedFilter(key, value, n, orderingProperty);
                ret.add(numberedFilter);
            }
            catch (Exception e) {
                logger.warn("Unable to eleborate result for {}", (Object)row.toString());
                e.printStackTrace();
            }
        }
        return ret;
    }

    public SortedSet<NumberedFilter> getFilterValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = ScopeProvider.instance.get();
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        int groupLevel = scopeDateGroupLevel = 2;
        String designDocId = this.getDesignDocId(clz) + "Value";
        String viewName = key;
        logger.trace("designDocId:{} view:{} ", (Object)designDocId, (Object)key);
        logger.trace("startKey:{}", (Object)startKey);
        logger.trace("groupLevel" + groupLevel);
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.descending(false);
        String orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        try {
            viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
        }
        catch (Exception e) {
            logger.error("error executing the query", (Throwable)e);
            throw e;
        }
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                if (o1.getValue() == null) {
                    o1.setValue(AccountingPersistenceQueryCouchBase.MAP_REDUCE__DESIGN);
                }
                if (o2.getValue() == null) {
                    o2.setValue(AccountingPersistenceQueryCouchBase.MAP_REDUCE__DESIGN);
                }
                return o1.getValue().compareTo(o2.getValue());
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        for (ViewRow row : viewResult) {
            String value = (String)row.value();
            NumberedFilter numberedFilter = new NumberedFilter(key, value, (Number)0, orderingProperty);
            ret.add(numberedFilter);
        }
        logger.trace("returning {} values", (Object)ret.size());
        return ret;
    }

    public JSONObject getUsageValue(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, Filter applicant) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = ScopeProvider.instance.get();
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        JsonArray endKey = JsonArray.create();
        endKey.add(currentScope);
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        startKey.add(applicant.getValue());
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        endKey.add(applicant.getValue());
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        int groupLevel = scopeDateGroupLevel = aggregationMode.ordinal() + 1 + 1 + 1;
        String designDocId = this.getDesignDocId(clz);
        String viewName = applicant.getKey();
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        try {
            viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (ViewRow row : viewResult) {
            JsonObject jsnobject = (JsonObject)row.value();
            JSONObject objJson = new JSONObject(jsnobject.toString());
            Iterator iterateJosn = objJson.keys();
            while (iterateJosn.hasNext()) {
                String key = (String)iterateJosn.next();
                Float valuetmp = Float.valueOf(Float.parseFloat(objJson.get(key).toString()));
                if (!key.equals("operationCount") && !key.equals("dataVolume")) continue;
                if (map.containsKey(key)) {
                    map.put(key, Float.valueOf(valuetmp.floatValue() + ((Float)map.get(key)).floatValue()));
                    continue;
                }
                map.put(key, valuetmp);
            }
        }
        JSONObject result = new JSONObject(map);
        return result;
    }

    public List<Filters> getUsageValueQuota(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filters> filterPackageQuota) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        String designDocId = this.getDesignDocId(clz);
        for (Filters singleFilter : filterPackageQuota) {
            ViewResult viewResult;
            Object temporal2;
            String viewNameTmp = null;
            JsonArray startKeyTmp = JsonArray.create();
            startKeyTmp.add(currentScope);
            JsonArray endKeyTmp = JsonArray.create();
            endKeyTmp.add(currentScope);
            int groupLevelTmp = 2;
            for (Filter filter : singleFilter.getFilters()) {
                viewNameTmp = groupLevelTmp == 2 ? filter.getKey() : viewNameTmp + KEYS_SEPARATOR + filter.getKey();
                startKeyTmp.add(filter.getValue());
                endKeyTmp.add(filter.getValue());
                ++groupLevelTmp;
            }
            for (Object temporal2 : temporalStartKey.toList()) {
                if (temporal2.toString().isEmpty()) continue;
                startKeyTmp.add(temporal2);
            }
            int count = 1;
            temporal2 = temporalEndKey.toList().iterator();
            while (temporal2.hasNext()) {
                Object temporal3 = temporal2.next();
                if (!temporal3.toString().isEmpty()) {
                    if (count == temporalEndKey.size()) {
                        temporal3 = (Integer)temporal3 + 1;
                    }
                    endKeyTmp.add(temporal3);
                }
                ++count;
            }
            ViewQuery query = ViewQuery.from((String)designDocId, (String)viewNameTmp);
            query.inclusiveEnd();
            query.groupLevel(groupLevelTmp);
            query.startKey(startKeyTmp);
            query.endKey(endKeyTmp);
            query.descending(false);
            logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewNameTmp, groupLevelTmp, startKeyTmp, endKeyTmp, temporalStartKey.toString(), temporalEndKey.toString()});
            try {
                viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage());
                throw e;
            }
            HashMap<String, Float> map = new HashMap<String, Float>();
            for (ViewRow row : viewResult) {
                JsonObject jsnobject = (JsonObject)row.value();
                JSONObject objJson = new JSONObject(jsnobject.toString());
                Iterator iterateJosn = objJson.keys();
                while (iterateJosn.hasNext()) {
                    String key = (String)iterateJosn.next();
                    Float valuetmp = Float.valueOf(Float.parseFloat(objJson.get(key).toString()));
                    if (!key.equals("operationCount") && !key.equals("dataVolume")) continue;
                    if (map.containsKey(key)) {
                        map.put(key, Float.valueOf(valuetmp.floatValue() + ((Float)map.get(key)).floatValue()));
                        if (designDocId.equals("StorageUsageRecord")) {
                            if (!key.equals("dataVolume")) continue;
                            singleFilter.setOrderingProperty(key);
                            singleFilter.setD(Double.valueOf(singleFilter.getD() + valuetmp.doubleValue()));
                            continue;
                        }
                        singleFilter.setOrderingProperty(key);
                        singleFilter.setD(Double.valueOf(singleFilter.getD() + valuetmp.doubleValue()));
                        continue;
                    }
                    map.put(key, valuetmp);
                    if (designDocId.equals("StorageUsageRecord")) {
                        if (!key.equals("dataVolume")) continue;
                        singleFilter.setOrderingProperty(key);
                        singleFilter.setD(Double.valueOf(valuetmp.doubleValue()));
                        continue;
                    }
                    singleFilter.setOrderingProperty(key);
                    singleFilter.setD(Double.valueOf(valuetmp.doubleValue()));
                }
            }
        }
        return filterPackageQuota;
    }

    public List<TotalFilters> getUsageValueQuotaTotal(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<TotalFilters> listUsage) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        String designDocId = this.getDesignDocId(clz);
        for (TotalFilters totalfilters : listUsage) {
            Double totalQuota = 0.0;
            for (Filters singleFilter : totalfilters.getTotalFilters()) {
                ViewResult viewResult;
                Object temporal2;
                String viewNameTmp = null;
                JsonArray startKeyTmp = JsonArray.create();
                startKeyTmp.add(currentScope);
                JsonArray endKeyTmp = JsonArray.create();
                endKeyTmp.add(currentScope);
                int groupLevelTmp = 2;
                for (Filter filter : singleFilter.getFilters()) {
                    viewNameTmp = groupLevelTmp == 2 ? filter.getKey() : viewNameTmp + KEYS_SEPARATOR + filter.getKey();
                    startKeyTmp.add(filter.getValue());
                    endKeyTmp.add(filter.getValue());
                    ++groupLevelTmp;
                }
                for (Object temporal2 : temporalStartKey.toList()) {
                    if (temporal2.toString().isEmpty()) continue;
                    startKeyTmp.add(temporal2);
                }
                int count = 1;
                temporal2 = temporalEndKey.toList().iterator();
                while (temporal2.hasNext()) {
                    Object temporal3 = temporal2.next();
                    if (!temporal3.toString().isEmpty()) {
                        if (count == temporalEndKey.size()) {
                            temporal3 = (Integer)temporal3 + 1;
                        }
                        endKeyTmp.add(temporal3);
                    }
                    ++count;
                }
                ViewQuery query = ViewQuery.from((String)designDocId, (String)viewNameTmp);
                query.inclusiveEnd();
                query.groupLevel(groupLevelTmp);
                query.startKey(startKeyTmp);
                query.endKey(endKeyTmp);
                query.descending(false);
                logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewNameTmp, groupLevelTmp, startKeyTmp, endKeyTmp, temporalStartKey.toString(), temporalEndKey.toString()});
                try {
                    viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage());
                    throw e;
                }
                HashMap<String, Float> map = new HashMap<String, Float>();
                for (ViewRow row : viewResult) {
                    JsonObject jsnobject = (JsonObject)row.value();
                    JSONObject objJson = new JSONObject(jsnobject.toString());
                    Iterator iterateJosn = objJson.keys();
                    while (iterateJosn.hasNext()) {
                        String key = (String)iterateJosn.next();
                        Float valuetmp = Float.valueOf(Float.parseFloat(objJson.get(key).toString()));
                        if (!key.equals("operationCount") && !key.equals("dataVolume")) continue;
                        if (map.containsKey(key)) {
                            map.put(key, Float.valueOf(valuetmp.floatValue() + ((Float)map.get(key)).floatValue()));
                            if (designDocId.equals("StorageUsageRecord")) {
                                if (!key.equals("dataVolume")) continue;
                                singleFilter.setOrderingProperty(key);
                                singleFilter.setD(Double.valueOf(singleFilter.getD() + valuetmp.doubleValue()));
                                totalQuota = totalQuota + (singleFilter.getD() + valuetmp.doubleValue());
                                continue;
                            }
                            singleFilter.setOrderingProperty(key);
                            singleFilter.setD(Double.valueOf(singleFilter.getD() + valuetmp.doubleValue()));
                            totalQuota = totalQuota + (singleFilter.getD() + valuetmp.doubleValue());
                            continue;
                        }
                        map.put(key, valuetmp);
                        if (designDocId.equals("StorageUsageRecord")) {
                            if (!key.equals("dataVolume")) continue;
                            singleFilter.setOrderingProperty(key);
                            singleFilter.setD(Double.valueOf(valuetmp.doubleValue()));
                            totalQuota = totalQuota + valuetmp.doubleValue();
                            continue;
                        }
                        singleFilter.setOrderingProperty(key);
                        singleFilter.setD(Double.valueOf(valuetmp.doubleValue()));
                        totalQuota = totalQuota + valuetmp.doubleValue();
                    }
                }
            }
            totalfilters.setD(totalQuota);
        }
        return listUsage;
    }
}

