/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

public enum KeyValueStatus {
    UNKNOWN(-1, "Unknown code (dummy value)"),
    SUCCESS(0, "The operation completed successfully"),
    ERR_NOT_FOUND(1, "The key does not exists"),
    ERR_EXISTS(2, "The key exists in the cluster (with another CAS value)"),
    ERR_TOO_BIG(3, "The document exceeds the maximum size"),
    ERR_INVALID(4, "Invalid request"),
    ERR_NOT_STORED(5, "The document was not stored for some reason"),
    ERR_DELTA_BADVAL(6, "Non-numeric server-side value for incr or decr"),
    ERR_NOT_MY_VBUCKET(7, "The server is not responsible for the requested vbucket"),
    ERR_NO_BUCKET(8, "Not connected to a bucket"),
    ERR_AUTH_STALE(31, "The authentication context is stale, reauthentication should be performed"),
    ERR_AUTH_ERROR(32, "Authentication failure"),
    ERR_AUTH_CONTINUE(33, "Authentication OK, but further action needed"),
    ERR_RANGE(34, "The requested value is outside the legal range"),
    ERR_ROLLBACK(35, "Roll back to an earlier version of the vbucket UUID"),
    ERR_ACCESS(36, "No access"),
    ERR_NOT_INITIALIZED(37, "The server is currently initializing this node"),
    ERR_UNKNOWN_COMMAND(129, "The server does not know this command"),
    ERR_NO_MEM(130, "Not enough memory"),
    ERR_NOT_SUPPORTED(131, "The server does not support this command"),
    ERR_INTERNAL(132, "An internal error in the server"),
    ERR_BUSY(133, "The system is currently too busy to handle the request"),
    ERR_TEMP_FAIL(134, "A temporary error condition occurred. Retrying the operation may resolve the problem."),
    ERR_SUBDOC_PATH_NOT_FOUND(192, "The provided path does not exist in the document"),
    ERR_SUBDOC_PATH_MISMATCH(193, "One of path components treats a non-dictionary as a dictionary, or a non-array as an array, or value the path points to is not a number"),
    ERR_SUBDOC_PATH_INVALID(194, "The path's syntax was incorrect"),
    ERR_SUBDOC_PATH_TOO_BIG(195, "The path provided is too large: either the string is too long, or it contains too many components"),
    ERR_SUBDOC_DOC_TOO_DEEP(196, "The document has too many levels to parse"),
    ERR_SUBDOC_VALUE_CANTINSERT(197, "The value provided will invalidate the JSON if inserted"),
    ERR_SUBDOC_DOC_NOT_JSON(198, "The existing document is not valid JSON"),
    ERR_SUBDOC_NUM_RANGE(199, "The existing number is out of the valid range for arithmetic operations"),
    ERR_SUBDOC_DELTA_RANGE(200, "The operation would result in a number outside the valid range"),
    ERR_SUBDOC_PATH_EXISTS(201, "The requested operation requires the path to not already exist, but it exists"),
    ERR_SUBDOC_VALUE_TOO_DEEP(202, "Inserting the value would cause the document to be too deep"),
    ERR_SUBDOC_INVALID_COMBO(203, "An invalid combination of commands was specified"),
    ERR_SUBDOC_MULTI_PATH_FAILURE(204, "Specified key was successfully found, but one or more path operations failed");

    private final short code;
    private final String description;

    private KeyValueStatus(short code, String description) {
        this.code = code;
        this.description = description;
    }

    public static KeyValueStatus valueOf(short code) {
        if (code == KeyValueStatus.SUCCESS.code) {
            return SUCCESS;
        }
        if (code == KeyValueStatus.ERR_NOT_FOUND.code) {
            return ERR_NOT_FOUND;
        }
        if (code == KeyValueStatus.ERR_EXISTS.code) {
            return ERR_EXISTS;
        }
        if (code == KeyValueStatus.ERR_NOT_MY_VBUCKET.code) {
            return ERR_NOT_MY_VBUCKET;
        }
        for (KeyValueStatus keyValueStatus : KeyValueStatus.values()) {
            if (keyValueStatus.code() != code) continue;
            return keyValueStatus;
        }
        return UNKNOWN;
    }

    public short code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }
}

