/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.exception.DuplicatedKeyFilterException;
import org.gcube.accounting.analytics.exception.ValueException;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingPersistenceQueryCouchBase
implements AccountingPersistenceBackendQuery {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceQueryCouchBase.class);
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String BUCKET_STORAGE_NAME_PROPERTY_KEY = "AggregatedStorageUsageRecord";
    public static final String BUCKET_SERVICE_NAME_PROPERTY_KEY = "AggregatedServiceUsageRecord";
    public static final String BUCKET_PORTLET_NAME_PROPERTY_KEY = "AggregatedPortletUsageRecord";
    public static final String BUCKET_JOB_NAME_PROPERTY_KEY = "AggregatedJobUsageRecord";
    public static final String BUCKET_TASK_NAME_PROPERTY_KEY = "AggregatedTaskUsageRecord";
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().queryEnabled(true).build();
    protected Cluster cluster;
    protected Bucket bucketStorage;
    protected String bucketNameStorage;
    protected Bucket bucketService;
    protected String bucketNameService;
    protected Bucket bucketPortlet;
    protected String bucketNamePortlet;
    protected Bucket bucketJob;
    protected String bucketNameJob;
    protected Bucket bucketTask;
    protected String bucketNameTask;
    private Map<String, Bucket> connectionMap;
    protected static final String MAP_REDUCE__DESIGN = "";
    protected static final String MAP_REDUCE_ALL = "all";
    protected static final String KEYS_SEPARATOR = "__";

    public void prepareConnection(AccountingPersistenceBackendQueryConfiguration configuration) throws Exception {
        String url = configuration.getProperty(URL_PROPERTY_KEY);
        String password = configuration.getProperty(PASSWORD_PROPERTY_KEY);
        this.cluster = CouchbaseCluster.create(ENV, url);
        this.bucketNameStorage = configuration.getProperty(BUCKET_STORAGE_NAME_PROPERTY_KEY);
        this.bucketNameService = configuration.getProperty(BUCKET_SERVICE_NAME_PROPERTY_KEY);
        this.bucketNameJob = configuration.getProperty(BUCKET_JOB_NAME_PROPERTY_KEY);
        this.bucketNamePortlet = configuration.getProperty(BUCKET_PORTLET_NAME_PROPERTY_KEY);
        this.bucketNameTask = configuration.getProperty(BUCKET_TASK_NAME_PROPERTY_KEY);
        this.connectionMap = new HashMap<String, Bucket>();
        this.bucketStorage = this.cluster.openBucket(this.bucketNameStorage, password);
        this.connectionMap.put(BUCKET_STORAGE_NAME_PROPERTY_KEY, this.bucketStorage);
        this.bucketService = this.cluster.openBucket(this.bucketNameService, password);
        this.connectionMap.put(BUCKET_SERVICE_NAME_PROPERTY_KEY, this.bucketService);
        this.bucketJob = this.cluster.openBucket(this.bucketNameJob, password);
        this.connectionMap.put(BUCKET_JOB_NAME_PROPERTY_KEY, this.bucketJob);
        this.bucketPortlet = this.cluster.openBucket(this.bucketNamePortlet, password);
        this.connectionMap.put(BUCKET_PORTLET_NAME_PROPERTY_KEY, this.bucketPortlet);
        this.bucketTask = this.cluster.openBucket(this.bucketNameTask, password);
        this.connectionMap.put(BUCKET_TASK_NAME_PROPERTY_KEY, this.bucketTask);
        logger.trace("Open cluster Service Bucket Url:" + url + " Pwd:" + configuration.getProperty(PASSWORD_PROPERTY_KEY) + " BucketName " + configuration.getProperty(BUCKET_SERVICE_NAME_PROPERTY_KEY));
    }

    public void close() throws Exception {
        this.cluster.disconnect();
    }

    protected Calendar getCalendar(JSONObject obj, TemporalConstraint.AggregationMode aggregationMode) throws NumberFormatException, JSONException {
        long millis;
        if (obj.has("startTime")) {
            millis = new Long(obj.getString("startTime"));
            logger.trace("The result {} was from an aggregated record. Using {}", (Object)obj.toString(), (Object)"startTime");
        } else {
            millis = new Long(obj.getString("creationTime"));
            logger.trace("The result {} was from single record. Using {}", (Object)obj.toString(), (Object)"creationTime");
        }
        Calendar calendar = TemporalConstraint.getAlignedCalendar((long)millis, (TemporalConstraint.AggregationMode)aggregationMode);
        logger.trace("{} has been aligned to {}", (Object)millis, (Object)calendar.getTimeInMillis());
        return calendar;
    }

    protected Map<Calendar, Info> selectQuery(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        String recordType = clz.newInstance().getRecordType();
        Expression expression = Expression.x("scope").eq(Expression.s(currentScope));
        expression = expression.and(Expression.x("recordType").eq(Expression.s(recordType)));
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        expression = expression.and(Expression.x("startTime").gt(startTime).or(Expression.x("creationTime").gt(startTime)));
        long endTime = temporalConstraint.getAlignedEndTime().getTimeInMillis();
        expression = expression.and(Expression.x("endTime").lt(endTime)).or(Expression.x("creationTime").lt(endTime));
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        if (filters != null) {
            for (Filter filter : filters) {
                expression = expression.and(Expression.x(filter.getKey()).eq(Expression.s(filter.getValue())));
            }
        }
        GroupByPath groupByPath = Select.select("*").from(this.connectionMap.get(clz.getSimpleName()).name()).where(expression);
        HashMap<Calendar, Info> map = new HashMap<Calendar, Info>();
        N1qlQueryResult result = this.connectionMap.get(clz.getSimpleName()).query(groupByPath);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), result.errors());
            return map;
        }
        List<N1qlQueryRow> rows = result.allRows();
        for (N1qlQueryRow row : rows) {
            try {
                logger.trace("Row : {}", (Object)row.toString());
                JsonObject jsonObject = row.value().getObject(clz.getSimpleName());
                logger.trace("JsonObject : {}", (Object)row.toString());
                String recordString = jsonObject.toMap().toString();
                logger.trace("Record String : {}", (Object)recordString);
                Record record = RecordUtility.getRecord((String)recordString);
                JSONObject obj = new JSONObject(jsonObject.toString());
                Calendar calendar = this.getCalendar(obj, aggregationMode);
                if (map.containsKey(calendar)) {
                    Info info = (Info)map.get(calendar);
                    JSONObject value = info.getValue();
                    jsonObject.toMap();
                } else {
                    map.put(calendar, new Info(calendar, obj));
                }
            }
            catch (Exception e) {
                logger.warn("Unable to eleborate result for {}", (Object)row.toString());
            }
            logger.trace("\n\n\n");
        }
        return map;
    }

    protected Calendar getCalendarFromArray(JsonArray array) throws JSONException {
        boolean startFound = false;
        Calendar calendar = Calendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        int count = 0;
        TemporalConstraint.CalendarEnum[] calendarValues = TemporalConstraint.CalendarEnum.values();
        for (int i = 0; i < array.size(); ++i) {
            try {
                int value = array.getInt(i);
                int calendarValue = calendarValues[count].getCalendarValue();
                if (calendarValue == 2) {
                    --value;
                }
                calendar.set(calendarValue, value);
                ++count;
                startFound = true;
                continue;
            }
            catch (Exception e) {
                if (startFound) break;
            }
        }
        for (int j = count; j < calendarValues.length; ++j) {
            if (calendarValues[j].getCalendarValue() == 5) {
                calendar.set(calendarValues[j].getCalendarValue(), 1);
                continue;
            }
            calendar.set(calendarValues[j].getCalendarValue(), 0);
        }
        return calendar;
    }

    protected JsonArray getRangeKey(long time, TemporalConstraint.AggregationMode aggregationMode, boolean wildCard, boolean endKey) throws JSONException {
        JsonArray array = JsonArray.create();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        TemporalConstraint.CalendarEnum[] values = TemporalConstraint.CalendarEnum.values();
        if (endKey) {
            calendar.add(values[aggregationMode.ordinal()].getCalendarValue(), 1);
        }
        for (int i = 0; i <= aggregationMode.ordinal(); ++i) {
            int value = calendar.get(values[i].getCalendarValue());
            if (values[i].getCalendarValue() == 2) {
                ++value;
            }
            array.add(value);
        }
        if (wildCard) {
            array.add("{}");
        }
        return array;
    }

    protected String getDesignDocId(Class<? extends AggregatedRecord<?, ?>> recordClass) throws InstantiationException, IllegalAccessException {
        return String.format("%s%s", MAP_REDUCE__DESIGN, recordClass.newInstance().getRecordType());
    }

    public static String getMapReduceFunctionName(Collection<String> collection) {
        String reduceFunction = MAP_REDUCE_ALL;
        if (!collection.isEmpty()) {
            reduceFunction = null;
            for (String property : collection) {
                if (reduceFunction == null) {
                    reduceFunction = property;
                    continue;
                }
                reduceFunction = reduceFunction + KEYS_SEPARATOR + property;
            }
        }
        return reduceFunction;
    }

    protected SortedMap<Calendar, Info> mapReduceQuery(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = ScopeProvider.instance.get();
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        JsonArray endKey = JsonArray.create();
        endKey.add(currentScope);
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
        TreeSet<String> keys = new TreeSet<String>();
        Collections.sort(filters, new Comparator<Filter>(){

            @Override
            public int compare(Filter filter1, Filter filter2) {
                return filter1.getKey().compareTo(filter2.getKey());
            }
        });
        logger.trace("filter" + filters.toString());
        if (filters != null && filters.size() != 0) {
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        startKey.add(filterValue);
                        endKey.add(filterValue);
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        int groupLevel = scopeDateGroupLevel = aggregationMode.ordinal() + 1 + 1;
        if (filters != null) {
            groupLevel += keys.size();
        }
        String designDocId = this.getDesignDocId(clz);
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        logger.trace("startKey:{}" + startKey);
        String viewName = AccountingPersistenceQueryCouchBase.getMapReduceFunctionName(keys);
        ViewQuery query = ViewQuery.from(designDocId, viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        TreeMap<Calendar, Info> infos = new TreeMap<Calendar, Info>();
        try {
            viewResult = this.connectionMap.get(clz.getSimpleName()).query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        for (ViewRow row : viewResult) {
            JsonArray array = (JsonArray)row.key();
            Calendar calendar = this.getCalendarFromArray(array);
            JsonObject value = (JsonObject)row.value();
            JSONObject obj = new JSONObject(value.toString());
            Info info = new Info(calendar, obj);
            infos.put(calendar, info);
        }
        return infos;
    }

    public SortedMap<Calendar, Info> getTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        return this.mapReduceQuery(clz, temporalConstraint, filters);
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String topKey, String orderingProperty) throws Exception {
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                return -o1.compareTo(o2);
            }
        };
        TreeMap<NumberedFilter, SortedMap<Calendar, Info>> ret = new TreeMap<NumberedFilter, SortedMap<Calendar, Info>>(comparator);
        SortedSet<NumberedFilter> top = this.getNextPossibleValues(clz, temporalConstraint, filters, topKey, orderingProperty);
        for (NumberedFilter nf : top) {
            filters.add((Filter)nf);
            SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters);
            ret.put(nf, map);
            filters.remove(nf);
        }
        return ret;
    }

    protected String getQualifiedProperty(String property) {
        return property;
    }

    protected String getSpecializedProperty(Class<? extends AggregatedRecord<?, ?>> clz, String property) {
        return String.format("%s.%s", this.connectionMap.get(clz.getSimpleName()).name(), property);
    }

    public SortedSet<NumberedFilter> getNextPossibleValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, String orderingProperty) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        String recordType = clz.newInstance().getRecordType();
        if (orderingProperty == null) {
            orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        }
        ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
        selectExpressions.add(Expression.x("SUM(" + this.getSpecializedProperty(clz, orderingProperty) + ")").as(orderingProperty));
        selectExpressions.add(Expression.x(this.getSpecializedProperty(clz, key)).as(key));
        Expression whereExpression = Expression.x(this.getSpecializedProperty(clz, "scope")).eq(Expression.s(currentScope));
        whereExpression = whereExpression.and("(" + Expression.x(this.getSpecializedProperty(clz, "recordType")).eq(Expression.s(recordType)).or(Expression.x(this.getSpecializedProperty(clz, "usageRecordType")).eq(Expression.s(recordType))) + ")");
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        whereExpression = whereExpression.and("(" + Expression.x(this.getSpecializedProperty(clz, "startTime")).gt(startTime).or(Expression.x(this.getSpecializedProperty(clz, "creationTime")).gt(startTime)) + ")");
        long endTime = temporalConstraint.getAlignedEndTime().getTimeInMillis();
        whereExpression = whereExpression.and("(" + Expression.x(this.getSpecializedProperty(clz, "endTime")).lt(endTime).or(Expression.x(this.getSpecializedProperty(clz, "creationTime")).lt(endTime)) + ")");
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
        TreeSet<String> keys = new TreeSet<String>();
        if (filters != null && filters.size() != 0) {
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        whereExpression = whereExpression.and(Expression.x(this.getSpecializedProperty(clz, filterKey)).eq(Expression.s(filterValue)));
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        Expression[] selectExpressionArray = new Expression[selectExpressions.size()];
        selectExpressions.toArray(selectExpressionArray);
        Sort sort = Sort.desc(orderingProperty);
        LimitPath path = Select.select(selectExpressionArray).from(this.connectionMap.get(clz.getSimpleName()).name()).where(whereExpression).groupBy(key).orderBy(sort);
        logger.debug(path.toString());
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                return -o1.compareTo(o2);
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        N1qlQueryResult result = this.connectionMap.get(clz.getSimpleName()).query(path);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), result.errors());
            throw new Exception("Query Failed :\n" + result.errors());
        }
        List<N1qlQueryRow> rows = result.allRows();
        for (N1qlQueryRow row : rows) {
            try {
                JsonObject jsonObject = row.value();
                String value = jsonObject.getString(key);
                Double n = jsonObject.getDouble(orderingProperty);
                NumberedFilter numberedFilter = new NumberedFilter(key, value, (Number)n, orderingProperty);
                ret.add(numberedFilter);
            }
            catch (Exception e) {
                logger.warn("Unable to eleborate result for {}", (Object)row.toString());
            }
        }
        return ret;
    }

    public SortedSet<NumberedFilter> getFilterValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        String recordType = clz.newInstance().getRecordType();
        String orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
        selectExpressions.add(Expression.x("SUM(" + this.getSpecializedProperty(clz, orderingProperty) + ")").as(orderingProperty));
        selectExpressions.add(Expression.x(this.getSpecializedProperty(clz, key)).as(key));
        Expression whereExpression = Expression.x(this.getSpecializedProperty(clz, "scope")).eq(Expression.s(currentScope));
        whereExpression = whereExpression.and("(" + Expression.x(this.getSpecializedProperty(clz, "recordType")).eq(Expression.s(recordType)).or(Expression.x(this.getSpecializedProperty(clz, "usageRecordType")).eq(Expression.s(recordType))) + ")");
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        whereExpression = whereExpression.and("(" + Expression.x(this.getSpecializedProperty(clz, "startTime")).gt(startTime).or(Expression.x(this.getSpecializedProperty(clz, "creationTime")).gt(startTime)) + ")");
        long endTime = temporalConstraint.getAlignedEndTime().getTimeInMillis();
        whereExpression = whereExpression.and("(" + Expression.x(this.getSpecializedProperty(clz, "endTime")).lt(endTime).or(Expression.x(this.getSpecializedProperty(clz, "creationTime")).lt(endTime)) + ")");
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz.newInstance());
        TreeSet<String> keys = new TreeSet<String>();
        Collections.sort(filters, new Comparator<Filter>(){

            @Override
            public int compare(Filter o1, Filter o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        if (filters != null && filters.size() != 0) {
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        whereExpression = whereExpression.and(Expression.x(this.getSpecializedProperty(clz, filterKey)).eq(Expression.s(filterValue)));
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        Expression[] selectExpressionArray = new Expression[selectExpressions.size()];
        selectExpressions.toArray(selectExpressionArray);
        Sort sort = Sort.asc(key);
        LimitPath path = Select.select(selectExpressionArray).from(this.connectionMap.get(clz.getSimpleName()).name()).where(whereExpression).groupBy(key).orderBy(sort);
        logger.debug(path.toString());
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        N1qlQueryResult result = this.connectionMap.get(clz.getSimpleName()).query(path);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), result.errors());
            throw new Exception("Query Failed :\n" + result.errors());
        }
        List<N1qlQueryRow> rows = result.allRows();
        for (N1qlQueryRow row : rows) {
            try {
                JsonObject jsonObject = row.value();
                logger.trace("JsonObject : {}", (Object)(row.value() + " key" + key));
                String value = jsonObject.getString(key);
                Double n = jsonObject.getDouble(orderingProperty);
                NumberedFilter numberedFilter = new NumberedFilter(key, value, (Number)n, orderingProperty);
                ret.add(numberedFilter);
            }
            catch (Exception e) {
                logger.warn("Unable to eleborate result for {}", (Object)row.toString());
            }
        }
        return ret;
    }
}

