/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.aggregation;

import java.util.Calendar;
import java.util.Date;
import org.gcube.accounting.aggregator.aggregation.AggregationType;
import org.gcube.com.fasterxml.jackson.annotation.JsonFormat;

public class AggregationInfo {
    protected String recordType;
    protected AggregationType aggregationType;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss.SSS Z")
    protected Date aggregationStartDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss.SSS Z")
    protected Date aggregationEndDate;

    private AggregationInfo() {
    }

    public AggregationInfo(AggregationInfo aggregationInfo) {
        this.recordType = aggregationInfo.getRecordType();
        this.aggregationType = aggregationInfo.getAggregationType();
        Calendar start = Calendar.getInstance();
        start.setTime(aggregationInfo.getAggregationStartDate());
        this.aggregationStartDate = start.getTime();
        Calendar end = Calendar.getInstance();
        end.setTime(aggregationInfo.getAggregationEndDate());
        this.aggregationEndDate = end.getTime();
    }

    public AggregationInfo(String recordType, AggregationType aggregationType, Date aggregationStartDate, Date aggregationEndDate) {
        this.recordType = recordType;
        this.aggregationType = aggregationType;
        this.aggregationStartDate = aggregationStartDate;
        this.aggregationEndDate = aggregationEndDate;
    }

    public Date getAggregationStartDate() {
        return this.aggregationStartDate;
    }

    public Date getAggregationEndDate() {
        return this.aggregationEndDate;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public String toString() {
        return String.format("[%s %s %s -> %s]", new Object[]{this.recordType, this.aggregationType, this.aggregationType.getDateFormat().format(this.aggregationStartDate), this.aggregationType.getDateFormat().format(this.aggregationEndDate)});
    }
}

