/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persist;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentElaboration {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String ID = "id";
    protected static final int THRESHOLD_FOR_FIVE_PERCENT = 100000;
    protected static final int THRESHOLD_FOR_ONE_PERCENT = 1000000;
    public static final int MAX_RETRY = 7;
    protected final AggregationStatus aggregationStatus;
    protected final File file;
    protected final AggregationState finalAggregationState;
    protected final int rowToBeElaborated;
    protected Calendar startTime;

    protected DocumentElaboration(AggregationStatus statusManager, AggregationState finalAggregationState, File file, int rowToBeElaborated) {
        this.aggregationStatus = statusManager;
        this.finalAggregationState = finalAggregationState;
        this.file = file;
        this.rowToBeElaborated = rowToBeElaborated;
    }

    protected void readFile() throws Exception {
        FileInputStream fstream = null;
        FilterInputStream in = null;
        BufferedReader br = null;
        try {
            String line;
            fstream = new FileInputStream(this.file);
            in = new DataInputStream(fstream);
            br = new BufferedReader(new InputStreamReader(in));
            this.logger.info("{} - Going to elaborate {} rows", (Object)this.aggregationStatus.getAggregationInfo(), (Object)this.rowToBeElaborated);
            int percentOfNumberOfRows = this.rowToBeElaborated / 10 + 1;
            if (this.rowToBeElaborated >= 100000) {
                percentOfNumberOfRows /= 2;
            }
            if (this.rowToBeElaborated >= 1000000) {
                percentOfNumberOfRows /= 5;
            }
            int elaborated = 0;
            while ((line = br.readLine()) != null) {
                boolean elaborate = true;
                long delay = TimeUnit.MILLISECONDS.toMillis(100L);
                int i = 0;
                while (elaborate) {
                    ++i;
                    try {
                        this.elaborateLine(line);
                        TimeUnit.MILLISECONDS.sleep(3L);
                        elaborate = false;
                    }
                    catch (Exception e) {
                        if (i != 1) {
                            this.logger.debug("Elaboration of line {} failed due to {}. Retrying {}{} time in {} {}", new Object[]{line, e.getMessage(), i, i == 2 ? "nd" : (i == 3 ? "rd" : "th"), delay, TimeUnit.MILLISECONDS.name().toLowerCase()});
                        } else {
                            this.logger.warn("Elaboration of line {} failed due to {}. Retrying in {} {}", new Object[]{line, e.getMessage(), delay, TimeUnit.MILLISECONDS.name().toLowerCase()});
                        }
                        if (i < 7) {
                            TimeUnit.MILLISECONDS.sleep(delay);
                            delay *= 2L;
                            continue;
                        }
                        throw e;
                    }
                }
                if (++elaborated % percentOfNumberOfRows == 0) {
                    int elaboratedPercentage = elaborated * 100 / this.rowToBeElaborated;
                    this.logger.info("{} - Elaborated {} rows of {} (about {}%)", new Object[]{this.aggregationStatus.getAggregationInfo(), elaborated, this.rowToBeElaborated, elaboratedPercentage});
                }
                if (elaborated <= this.rowToBeElaborated) continue;
                throw new Exception("Elaborated file line is number " + elaborated + " > " + this.rowToBeElaborated + " (total number of rows to elaborate). This is really strange and should not occur. Stopping execution");
            }
            if (elaborated != this.rowToBeElaborated) {
                throw new Exception("Elaborated file line is number " + elaborated + " != " + this.rowToBeElaborated + "(total number of rows to elaborate). This is really strange and should not occur. Stopping execution");
            }
            this.logger.info("{} - Elaborated {} rows of {} ({}%)", new Object[]{this.aggregationStatus.getAggregationInfo(), elaborated, this.rowToBeElaborated, 100});
        }
        catch (Exception e) {
            this.logger.error("Error while elaborating file {}", (Object)this.file.getAbsolutePath(), (Object)e);
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
            if (fstream != null) {
                fstream.close();
            }
        }
    }

    public void elaborate() throws Exception {
        this.startTime = Utility.getUTCCalendarInstance();
        this.readFile();
        this.afterElaboration();
        this.aggregationStatus.setAggregationState(this.finalAggregationState, this.startTime, true);
    }

    protected abstract void elaborateLine(String var1) throws Exception;

    protected abstract void afterElaboration() throws Exception;
}

