/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.plugin;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.gcube.accounting.aggregator.aggregation.AggregationType;
import org.gcube.accounting.aggregator.elaboration.AggregatorManager;
import org.gcube.accounting.aggregator.elaboration.RecoveryManager;
import org.gcube.accounting.aggregator.plugin.AccountingAggregatorPluginDeclaration;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingAggregatorPlugin
extends Plugin<AccountingAggregatorPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(AccountingAggregatorPlugin.class);
    public static final String AGGREGATION_TYPE_INPUT_PARAMETER = "aggregationType";
    public static final String AGGREGATION_START_DATE_INPUT_PARAMETER = "aggregationStartDate";
    public static final String AGGREGATION_END_DATE_INPUT_PARAMETER = "aggregationEndDate";
    public static final String RESTART_FROM_LAST_AGGREGATION_DATE_INPUT_PARAMETER = "restartFromLastAggregationDate";
    public static final String AGGREGATION_START_DATE_DATE_FORMAT_PATTERN = "yyyy/MM/dd";
    public static final DateFormat AGGREGATION_START_DATE_DATE_FORMAT;
    private static final String AGGREGATION_START_END_DATE_UTC_DATE_FORMAT_PATTERN = "yyyy/MM/dd Z";
    private static final DateFormat AGGREGATION_START_END_DATE_UTC_DATE_FORMAT;
    private static final String UTC = "+0000";
    public static final String ELABORATION_TYPE_INPUT_PARAMETER = "elaborationType";
    public static final String PERSIST_START_TIME_INPUT_PARAMETER = "persistStartTime";
    public static final String PERSIST_END_TIME_INPUT_PARAMETER = "persistEndTime";
    public static final String PERSIST_TIME_DATE_FORMAT_PATTERN = "HH:mm";
    public static final DateFormat PERSIST_TIME_DATE_FORMAT;
    public static final String LOCAL_TIME_DATE_FORMAT_PATTERN = "HH:mm Z";
    public static final DateFormat LOCAL_TIME_DATE_FORMAT;
    public static final String RECORD_TYPE_INPUT_PARAMETER = "recordType";

    public AccountingAggregatorPlugin(AccountingAggregatorPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
    }

    private Date getPersistTime(Map<String, Object> inputs, String parameterName) throws ParseException {
        Date persistTime = null;
        if (inputs.containsKey(parameterName)) {
            String persistTimeString = (String)inputs.get(parameterName);
            persistTime = Utility.getPersistTimeDate(persistTimeString);
        }
        if (persistTime == null) {
            throw new IllegalArgumentException("Please set a valid '" + parameterName + "' by using " + PERSIST_TIME_DATE_FORMAT_PATTERN + " format.");
        }
        return persistTime;
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        String aggregationStartDateString;
        AggregationType aggregationType = null;
        Date aggregationStartDate = null;
        Date aggregationEndDate = null;
        boolean restartFromLastAggregationDate = false;
        ElaborationType elaborationType = ElaborationType.AGGREGATE;
        Date persistStartTime = null;
        Date persistEndTime = null;
        Class usageRecordClass = null;
        if (inputs == null || inputs.isEmpty()) {
            throw new IllegalArgumentException("The can only be launched providing valid input parameters");
        }
        if (inputs.containsKey(ELABORATION_TYPE_INPUT_PARAMETER)) {
            elaborationType = ElaborationType.valueOf((String)inputs.get(ELABORATION_TYPE_INPUT_PARAMETER));
        }
        persistStartTime = this.getPersistTime(inputs, PERSIST_START_TIME_INPUT_PARAMETER);
        persistEndTime = this.getPersistTime(inputs, PERSIST_END_TIME_INPUT_PARAMETER);
        if (inputs.containsKey(AGGREGATION_START_DATE_INPUT_PARAMETER)) {
            aggregationStartDateString = (String)inputs.get(AGGREGATION_START_DATE_INPUT_PARAMETER);
            aggregationStartDate = AGGREGATION_START_END_DATE_UTC_DATE_FORMAT.parse(aggregationStartDateString + " " + UTC);
        }
        if (inputs.containsKey(AGGREGATION_END_DATE_INPUT_PARAMETER)) {
            String aggregationEndDateString = (String)inputs.get(AGGREGATION_END_DATE_INPUT_PARAMETER);
            aggregationEndDate = AGGREGATION_START_END_DATE_UTC_DATE_FORMAT.parse(aggregationEndDateString + " " + UTC);
        }
        switch (elaborationType) {
            case AGGREGATE: {
                if (!inputs.containsKey(AGGREGATION_TYPE_INPUT_PARAMETER)) {
                    throw new IllegalArgumentException("Please set required parameter 'aggregationType'");
                }
                aggregationType = AggregationType.valueOf((String)inputs.get(AGGREGATION_TYPE_INPUT_PARAMETER));
                if (inputs.containsKey(AGGREGATION_START_DATE_INPUT_PARAMETER)) {
                    aggregationStartDateString = (String)inputs.get(AGGREGATION_START_DATE_INPUT_PARAMETER);
                    aggregationStartDate = AGGREGATION_START_END_DATE_UTC_DATE_FORMAT.parse(aggregationStartDateString + " " + UTC);
                }
                if (inputs.containsKey(RESTART_FROM_LAST_AGGREGATION_DATE_INPUT_PARAMETER)) {
                    restartFromLastAggregationDate = (Boolean)inputs.get(RESTART_FROM_LAST_AGGREGATION_DATE_INPUT_PARAMETER);
                }
                if (!restartFromLastAggregationDate && aggregationStartDate == null) {
                    throw new IllegalArgumentException("Aggregation Start Date cannot be found. Please provide it as parameter or set 'restartFromLastAggregationDate' input parameter to 'true'.");
                }
                if (inputs.containsKey(RECORD_TYPE_INPUT_PARAMETER)) {
                    usageRecordClass = RecordUtility.getRecordClass((String)((String)inputs.get(RECORD_TYPE_INPUT_PARAMETER)));
                }
                AggregatorManager aggregatorManager = new AggregatorManager(aggregationType, restartFromLastAggregationDate, aggregationStartDate, aggregationEndDate);
                aggregatorManager.elaborate(persistStartTime, persistEndTime, usageRecordClass);
                break;
            }
            case RECOVERY: {
                RecoveryManager recoveryManager = new RecoveryManager(persistStartTime, persistEndTime, aggregationStartDate, aggregationEndDate);
                recoveryManager.recovery();
                break;
            }
            default: {
                throw new IllegalArgumentException("No ElaborationType provided. You should not be here. Please Contact the administrator");
            }
        }
    }

    protected void onStop() throws Exception {
        logger.trace("Stopping execution of {}, UUID : {}", (Object)"Accounting-Aggregator-Plugin", (Object)this.uuid);
        Thread.currentThread().interrupt();
    }

    static {
        RecordUtility.addRecordPackage((Package)ServiceUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedServiceUsageRecord.class.getPackage());
        AGGREGATION_START_DATE_DATE_FORMAT = Utility.getUTCDateFormat(AGGREGATION_START_DATE_DATE_FORMAT_PATTERN);
        AGGREGATION_START_END_DATE_UTC_DATE_FORMAT = Utility.getUTCDateFormat(AGGREGATION_START_END_DATE_UTC_DATE_FORMAT_PATTERN);
        PERSIST_TIME_DATE_FORMAT = new SimpleDateFormat(PERSIST_TIME_DATE_FORMAT_PATTERN);
        LOCAL_TIME_DATE_FORMAT = new SimpleDateFormat(LOCAL_TIME_DATE_FORMAT_PATTERN);
    }

    public static enum ElaborationType {
        AGGREGATE,
        RECOVERY;

    }
}

