/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persist;

import com.couchbase.client.java.Bucket;
import java.io.File;
import java.util.Calendar;
import org.gcube.accounting.aggregator.directory.WorkSpaceDirectoryStructure;
import org.gcube.accounting.aggregator.persist.DeleteDocument;
import org.gcube.accounting.aggregator.persist.InsertDocument;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.aggregator.workspace.WorkSpaceManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persist {
    private static Logger logger = LoggerFactory.getLogger(Persist.class);
    protected final AggregationStatus aggregationStatus;
    protected final Bucket originalRecordBucket;
    protected final Bucket aggregatedRecordBucket;
    protected final File originalRecordsbackupFile;
    protected final File aggregateRecordsBackupFile;

    public Persist(AggregationStatus aggregationStatus, Bucket originalRecordBucket, Bucket aggregatedRecordBucket, File originalRecordsbackupFile, File aggregateRecordsBackupFile) {
        this.aggregationStatus = aggregationStatus;
        this.originalRecordBucket = originalRecordBucket;
        this.aggregatedRecordBucket = aggregatedRecordBucket;
        this.originalRecordsbackupFile = originalRecordsbackupFile;
        this.aggregateRecordsBackupFile = aggregateRecordsBackupFile;
    }

    private void setAggregationStateToCompleted(Calendar now) throws Exception {
        this.originalRecordsbackupFile.delete();
        this.aggregateRecordsBackupFile.delete();
        this.aggregationStatus.setState(AggregationState.COMPLETED, now, true);
    }

    public void recover() throws Exception {
        if (this.aggregationStatus.getAggregatedRecordsNumber() == this.aggregationStatus.getOriginalRecordsNumber() && (this.originalRecordBucket.name().compareTo(this.aggregatedRecordBucket.name()) == 0 || this.aggregationStatus.getAggregatedRecordsNumber() == 0)) {
            Calendar now = Utility.getUTCCalendarInstance();
            logger.info("{} - OriginalRecords are {}. AggregatedRecords are {} ({}=={}). All records were already aggregated. The aggregation didn't had any effects and the Source and Destination Bucket are the same ({}) or the record number is 0. Setting {} to {}", new Object[]{this.aggregationStatus.getAggregationInfo(), this.aggregationStatus.getOriginalRecordsNumber(), this.aggregationStatus.getAggregatedRecordsNumber(), this.aggregationStatus.getOriginalRecordsNumber(), this.aggregationStatus.getAggregatedRecordsNumber(), this.originalRecordBucket.name(), AggregationState.class.getSimpleName(), AggregationState.COMPLETED});
            this.setAggregationStateToCompleted(now);
            return;
        }
        if (AggregationState.canContinue(this.aggregationStatus.getAggregationState(), AggregationState.AGGREGATED)) {
            DeleteDocument deleteDocument = new DeleteDocument(this.aggregationStatus, this.originalRecordsbackupFile, this.originalRecordBucket);
            deleteDocument.elaborate();
        }
        if (AggregationState.canContinue(this.aggregationStatus.getAggregationState(), AggregationState.DELETED)) {
            InsertDocument insertDocument = new InsertDocument(this.aggregationStatus, this.aggregateRecordsBackupFile, this.aggregatedRecordBucket);
            insertDocument.elaborate();
        }
        if (AggregationState.canContinue(this.aggregationStatus.getAggregationState(), AggregationState.ADDED)) {
            Calendar now = Utility.getUTCCalendarInstance();
            WorkSpaceDirectoryStructure workspaceDirectoryStructure = new WorkSpaceDirectoryStructure();
            String targetFolder = (String)workspaceDirectoryStructure.getTargetFolder(this.aggregationStatus.getAggregationInfo().getAggregationType(), this.aggregationStatus.getAggregationInfo().getAggregationStartDate());
            WorkSpaceManagement.zipAndBackupFiles(targetFolder, this.originalRecordsbackupFile.getName().replace(".original.json", ""), this.originalRecordsbackupFile, this.aggregateRecordsBackupFile);
            this.setAggregationStateToCompleted(now);
        }
    }
}

