/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persist;

import com.couchbase.client.java.Bucket;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentElaboration {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String ID = "id";
    protected final AggregationStatus aggregationStatus;
    protected final File file;
    protected final Bucket bucket;
    protected final AggregationState finalAggregationState;
    protected final int rowToBeElaborated;
    protected Calendar startTime;

    protected DocumentElaboration(AggregationStatus statusManager, AggregationState finalAggregationState, File file, Bucket bucket, int rowToBeElaborated) {
        this.aggregationStatus = statusManager;
        this.finalAggregationState = finalAggregationState;
        this.file = file;
        this.bucket = bucket;
        this.rowToBeElaborated = rowToBeElaborated;
    }

    protected void readFile() throws Exception {
        try {
            String line;
            FileInputStream fstream = new FileInputStream(this.file);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            this.logger.info("{} - Going to elaborate {} rows", (Object)this.aggregationStatus.getAggregationInfo(), (Object)this.rowToBeElaborated);
            int tenPercentOfNumberOfRows = this.rowToBeElaborated / 10 + 1;
            int elaborated = 0;
            while ((line = br.readLine()) != null) {
                this.elaborateLine(line);
                if (++elaborated % tenPercentOfNumberOfRows != 0) continue;
                int elaboratedPercentage = elaborated * 100 / this.rowToBeElaborated;
                this.logger.info("{} - Elaborated {} rows of {} (about {}%)", new Object[]{this.aggregationStatus.getAggregationInfo(), elaborated, this.rowToBeElaborated, elaboratedPercentage});
            }
            this.logger.info("{} - Elaborated {} rows of {} ({}%)", new Object[]{this.aggregationStatus.getAggregationInfo(), elaborated, this.rowToBeElaborated, 100});
            br.close();
            in.close();
            fstream.close();
        }
        catch (Exception e) {
            this.logger.error("Error while elaborating file {}", (Object)this.file.getAbsolutePath(), (Object)e);
            throw e;
        }
    }

    public void elaborate() throws Exception {
        this.startTime = Utility.getUTCCalendarInstance();
        this.readFile();
        this.aggregationStatus.setState(this.finalAggregationState, this.startTime, true);
        this.afterElaboration();
    }

    protected abstract void elaborateLine(String var1) throws Exception;

    protected abstract void afterElaboration() throws Exception;
}

