/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.elaboration;

import java.util.Date;
import java.util.List;
import org.gcube.accounting.aggregator.elaboration.Elaborator;
import org.gcube.accounting.aggregator.persistence.CouchBaseConnector;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.documentstore.records.DSMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryManager {
    private static Logger logger = LoggerFactory.getLogger(RecoveryManager.class);
    protected final Date persistStartTime;
    protected final Date persistEndTime;

    public RecoveryManager(Date persistStartTime, Date persistEndTime) {
        this.persistStartTime = persistStartTime;
        this.persistEndTime = persistEndTime;
    }

    public void recovery() throws Exception {
        List<AggregationStatus> aggregationStatusList = CouchBaseConnector.getUnterminated();
        if (aggregationStatusList.size() == 0) {
            logger.info("Nothing to recover :)");
        }
        for (AggregationStatus aggregationStatus : aggregationStatusList) {
            logger.info("Going to Recover unterminated elaboration {}", (Object)DSMapper.getObjectMapper().writeValueAsString((Object)aggregationStatus));
            Elaborator elaborator = new Elaborator(aggregationStatus, this.persistStartTime, this.persistEndTime);
            elaborator.elaborate();
        }
    }
}

