/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.core.LazyValue;
import org.apache.jackrabbit.oak.core.SecureNodeState;
import org.apache.jackrabbit.oak.kernel.FastMove;
import org.apache.jackrabbit.oak.kernel.KernelNodeBuilder;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class SecureNodeBuilder
implements NodeBuilder,
FastMove {
    private final SecureNodeBuilder rootBuilder;
    private final SecureNodeBuilder parent;
    private final String name;
    private final LazyValue<PermissionProvider> permissionProvider;
    private final Context acContext;
    private final NodeBuilder builder;
    private TreePermission treePermission = null;
    private TreePermission rootPermission = null;

    SecureNodeBuilder(@Nonnull NodeBuilder builder, @Nonnull LazyValue<PermissionProvider> permissionProvider, @Nonnull Context acContext) {
        this.rootBuilder = this;
        this.parent = null;
        this.name = null;
        this.permissionProvider = Preconditions.checkNotNull(permissionProvider);
        this.acContext = Preconditions.checkNotNull(acContext);
        this.builder = Preconditions.checkNotNull(builder);
    }

    private SecureNodeBuilder(SecureNodeBuilder parent, String name) {
        this.rootBuilder = parent.rootBuilder;
        this.parent = parent;
        this.name = name;
        this.permissionProvider = parent.permissionProvider;
        this.acContext = parent.acContext;
        this.builder = parent.builder.getChildNode(name);
    }

    @Override
    @Nonnull
    public NodeState getBaseState() {
        return new SecureNodeState(this.builder.getBaseState(), this.getTreePermission());
    }

    @Override
    @Nonnull
    public NodeState getNodeState() {
        return new SecureNodeState(this.builder.getNodeState(), this.getTreePermission());
    }

    @Override
    public boolean exists() {
        return this.builder.exists() && (this.builder.isReplaced() || this.getTreePermission().canRead());
    }

    @Override
    public boolean isNew() {
        return this.builder.isNew() || this.builder.isReplaced() && !this.getTreePermission().canRead();
    }

    @Override
    public boolean isNew(String name) {
        return this.builder.isNew(name) || this.builder.isReplaced(name) && !this.getTreePermission().canRead(this.builder.getProperty(name));
    }

    @Override
    public boolean isModified() {
        return this.builder.isModified();
    }

    @Override
    public boolean isReplaced() {
        return this.builder.isReplaced() && !this.isNew();
    }

    @Override
    public boolean isReplaced(String name) {
        return this.builder.isReplaced(name) && !this.isNew(name);
    }

    public void baseChanged() {
        Preconditions.checkState(this.parent == null);
        this.treePermission = null;
        this.rootPermission = null;
        this.getTreePermission();
    }

    @Override
    public boolean remove() {
        return this.exists() && this.builder.remove();
    }

    @Override
    public boolean moveTo(NodeBuilder newParent, String newName) {
        return this.exists() && this.builder.moveTo(newParent, newName);
    }

    @Override
    @CheckForNull
    public PropertyState getProperty(String name) {
        PropertyState property = this.builder.getProperty(name);
        if (property != null && new ReadablePropertyPredicate().apply(property)) {
            return property;
        }
        return null;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    @Override
    public synchronized long getPropertyCount() {
        if (this.getTreePermission().canReadProperties() || this.isNew()) {
            return this.builder.getPropertyCount();
        }
        return Iterables.size(Iterables.filter(this.builder.getProperties(), new ReadablePropertyPredicate()));
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        if (this.getTreePermission().canReadProperties() || this.isNew()) {
            return this.builder.getProperties();
        }
        return Iterables.filter(this.builder.getProperties(), new ReadablePropertyPredicate());
    }

    @Override
    public boolean getBoolean(String name) {
        PropertyState property = this.getProperty(name);
        return property != null && property.getType() == Type.BOOLEAN && property.getValue(Type.BOOLEAN) != false;
    }

    @Override
    @CheckForNull
    public String getString(@Nonnull String name) {
        PropertyState property = this.getProperty(name);
        if (property != null && property.getType() == Type.STRING) {
            return property.getValue(Type.STRING);
        }
        return null;
    }

    @Override
    @CheckForNull
    public String getName(@Nonnull String name) {
        PropertyState property = this.getProperty(name);
        if (property != null && property.getType() == Type.NAME) {
            return property.getValue(Type.NAME);
        }
        return null;
    }

    @Override
    @Nonnull
    public Iterable<String> getNames(@Nonnull String name) {
        PropertyState property = this.getProperty(name);
        if (property != null && property.getType() == Type.NAMES) {
            return property.getValue(Type.NAMES);
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public NodeBuilder setProperty(@Nonnull PropertyState property) {
        this.builder.setProperty(property);
        return this;
    }

    @Override
    @Nonnull
    public <T> NodeBuilder setProperty(String name, @Nonnull T value) {
        this.builder.setProperty(name, value);
        return this;
    }

    @Override
    @Nonnull
    public <T> NodeBuilder setProperty(String name, @Nonnull T value, Type<T> type) {
        this.builder.setProperty(name, value, type);
        return this;
    }

    @Override
    @Nonnull
    public NodeBuilder removeProperty(String name) {
        if (this.hasProperty(name)) {
            this.builder.removeProperty(name);
        }
        return this;
    }

    @Override
    @Nonnull
    public Iterable<String> getChildNodeNames() {
        return Iterables.filter(this.builder.getChildNodeNames(), new Predicate<String>(){

            @Override
            public boolean apply(@Nullable String input) {
                return input != null && SecureNodeBuilder.this.getChildNode(input).exists();
            }
        });
    }

    @Override
    public boolean hasChildNode(@Nonnull String name) {
        if (this.builder.hasChildNode(name)) {
            return this.getChildNode(name).exists();
        }
        return false;
    }

    @Override
    @Nonnull
    public NodeBuilder child(@Nonnull String name) {
        if (this.hasChildNode(name)) {
            return this.getChildNode(name);
        }
        return this.setChildNode(name);
    }

    @Override
    @Nonnull
    public NodeBuilder setChildNode(@Nonnull String name) {
        this.builder.setChildNode(name);
        return new SecureNodeBuilder(this, name);
    }

    @Override
    @Nonnull
    public NodeBuilder setChildNode(String name, @Nonnull NodeState nodeState) {
        this.builder.setChildNode(name, nodeState);
        return new SecureNodeBuilder(this, name);
    }

    @Override
    public NodeBuilder getChildNode(@Nonnull String name) {
        return new SecureNodeBuilder(this, name);
    }

    @Override
    public synchronized long getChildNodeCount(long max) {
        if (this.getTreePermission().canReadAll()) {
            return this.builder.getChildNodeCount(max);
        }
        return Iterables.size(this.getChildNodeNames());
    }

    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        return this.builder.createBlob(stream);
    }

    @Override
    public boolean moveFrom(KernelNodeBuilder source, String newName) {
        return source.moveTo(this.builder, newName);
    }

    private TreePermission getTreePermission() {
        if (this.treePermission == null || this.rootPermission != this.rootBuilder.treePermission) {
            NodeState base = this.builder.getBaseState();
            if (this.parent == null) {
                ImmutableTree baseTree = new ImmutableTree(base);
                this.rootPermission = this.treePermission = this.permissionProvider.get().getTreePermission(baseTree, TreePermission.EMPTY);
            } else {
                this.treePermission = this.parent.getTreePermission().getChildPermission(this.name, base);
                this.rootPermission = this.parent.rootPermission;
            }
        }
        return this.treePermission;
    }

    private class ReadablePropertyPredicate
    implements Predicate<PropertyState> {
        private ReadablePropertyPredicate() {
        }

        @Override
        public boolean apply(@Nonnull PropertyState property) {
            return SecureNodeBuilder.this.getTreePermission().canRead(property) || SecureNodeBuilder.this.isNew(property.getName());
        }
    }
}

