/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.commons.FieldCleanupAdapter;
import org.objectweb.asm.commons.MethodCleanupAdapter;

public class ClassCleanupAdapter
extends ClassAdapter {
    public static final int CLEAR_DEBUG = 1;
    public static final int CLEAR_INNER = 2;
    public static final int CLEAR_OUTER = 4;
    public static final int CLEAR_SIGNATURES = 8;
    public static final int CLEAR_ANNOTATIONS = 16;
    public static final int CLEAR_ATTRIBUTES = 32;
    public static final int CLEAR_LOCALS = 64;
    public static final int CLEAR_LINES = 128;
    public static final int CLEAR_FRAMES = 256;
    public static EmptyVisitor emptyVisitor = new EmptyVisitor();
    boolean clearDebug;
    boolean clearInner;
    boolean clearOuter;
    boolean clearSignatures;
    boolean clearAnnotations;
    boolean clearAttributes;
    boolean clearLocals;
    boolean clearLines;
    boolean clearFrames;
    private int flow;

    public ClassCleanupAdapter(ClassVisitor classVisitor, int n) {
        super(classVisitor);
        this.clearDebug = (n & 1) != 0;
        this.clearInner = (n & 2) != 0;
        this.clearOuter = (n & 4) != 0;
        this.clearSignatures = (n & 8) != 0;
        this.clearAnnotations = (n & 0x10) != 0;
        this.clearAttributes = (n & 0x20) != 0;
        this.clearLocals = (n & 0x40) != 0;
        this.clearLines = (n & 0x80) != 0;
        this.clearFrames = (n & 0x100) != 0;
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.cv.visit(n, n2, string, this.clearSignatures ? null : string2, string3, stringArray);
    }

    public void visitSource(String string, String string2) {
        if (!this.clearDebug) {
            this.cv.visitSource(string, string2);
        }
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        FieldVisitor fieldVisitor = this.cv.visitField(n, string, string2, this.clearSignatures ? null : string3, object);
        return this.clearAnnotations || this.clearAttributes ? new FieldCleanupAdapter(fieldVisitor, this) : fieldVisitor;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, this.clearSignatures ? null : string3, stringArray);
        return this.clearAttributes || this.clearAttributes || this.clearSignatures || this.clearLines || this.clearLocals || this.clearFrames ? new MethodCleanupAdapter(methodVisitor, this) : methodVisitor;
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        if (!this.clearInner) {
            this.cv.visitInnerClass(string, string2, string3, n);
        }
    }

    public void visitOuterClass(String string, String string2, String string3) {
        if (!this.clearOuter) {
            this.cv.visitOuterClass(string, string2, string3);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        return this.clearAnnotations ? emptyVisitor : this.cv.visitAnnotation(string, bl);
    }

    public void visitAttribute(Attribute attribute) {
        if (!this.clearAttributes) {
            this.cv.visitAttribute(attribute);
        }
    }
}

