/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibary.model.versioning.WorkspaceVersion;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.common.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRAccessManager;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryCreate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryDelete;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryDisabledPublicAccess;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryEnabledPublicAccess;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRead;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRestore;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntrySetACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryShare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUnshare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.lock.JCRLockManager;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.portlets.user.urlshortener.UrlShortener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JCRWorkspaceItem
implements WorkspaceItem {
    protected JCRWorkspace workspace;
    public ItemDelegate delegate;
    private ItemDelegate parentDelegate;
    protected static Logger logger = LoggerFactory.getLogger(JCRWorkspaceItem.class);

    public JCRWorkspaceItem(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        this.workspace = workspace;
        this.delegate = delegate;
        System.out.println("--");
    }

    public JCRWorkspaceItem(JCRWorkspace workspace, ItemDelegate delegate, String name, String description) throws RepositoryException {
        Validate.notNull(name, "Name must be not null");
        Validate.notNull(description, "Description must be not null");
        this.workspace = workspace;
        this.delegate = delegate;
        String portalLogin = workspace.getOwner().getPortalLogin();
        delegate.setLastModifiedBy(portalLogin);
        delegate.setDescription(description);
        delegate.setTitle(name);
        delegate.setLastAction(WorkspaceItemAction.CREATED);
        delegate.setOwner(portalLogin);
        delegate.setProperties(new HashMap<NodeProperty, String>());
    }

    public void setMetadata(Map<String, String> properties) {
        this.delegate.setMetadata(properties);
    }

    @Override
    public String getId() throws InternalErrorException {
        System.out.println("get ID " + this.delegate.getId());
        return this.delegate.getId();
    }

    @Override
    public User getOwner() {
        return new JCRUser("", this.delegate.getOwner());
    }

    @Override
    public String getName() throws InternalErrorException {
        return this.delegate.getTitle();
    }

    @Override
    public String getDescription() throws InternalErrorException {
        return this.delegate.getDescription();
    }

    @Override
    public Calendar getCreationTime() throws InternalErrorException {
        return this.delegate.getCreationTime();
    }

    @Override
    public Calendar getLastModificationTime() throws InternalErrorException {
        return this.delegate.getLastModificationTime();
    }

    @Override
    public WorkspaceItemAction getLastAction() throws InternalErrorException {
        return this.delegate.getLastAction();
    }

    @Override
    public Capabilities getCapabilities() {
        return null;
    }

    @Override
    public Properties getProperties() throws InternalErrorException {
        try {
            return new JCRProperties(this.delegate, this.workspace.getOwner().getPortalLogin());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public String getPath() throws InternalErrorException {
        try {
            System.out.println("GET PATH OF " + this.delegate.getName());
            return this.getPath(this.delegate);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalErrorException(e);
        }
    }

    protected String getPath(ItemDelegate item) throws InternalErrorException, Exception {
        String nodePath = item.getPath();
        if (item.getId().equals(this.workspace.getRoot().getId())) {
            return this.workspace.getPathSeparator() + this.delegate.getTitle();
        }
        if (nodePath.startsWith("/Chat/")) {
            return nodePath;
        }
        if (!item.isShared() && !nodePath.startsWith("/Share/")) {
            return this.workspace.getRelativePath(item.getPath());
        }
        JCRAbstractWorkspaceFolder folder = this.getParent(item);
        String path = folder.getPath() + this.workspace.getPathSeparator() + this.delegate.getTitle();
        return path;
    }

    @Override
    public boolean isRoot() throws InternalErrorException {
        return this.getParent() == null;
    }

    @Override
    public String getIdSharedFolder() throws InternalErrorException {
        return this.delegate.getProperties().get((Object)NodeProperty.SHARED_ROOT_ID);
    }

    public ItemDelegate save() throws RepositoryException {
        ItemDelegate item = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            item = servlets.saveItem(this.delegate, false);
            if (item != null) {
                this.delegate.setId(item.getId());
                this.delegate.setPath(item.getPath());
                this.delegate.setCreationTime(item.getCreationTime());
                this.delegate.setLastModificationTime(item.getLastModificationTime());
                this.delegate.setProperties(item.getProperties());
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
        return item;
    }

    public ItemDelegate save(InputStream is) throws RepositoryException {
        ItemDelegate item = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            item = servlets.createItem(this.delegate, is);
            if (item != null) {
                this.delegate.setId(item.getId());
                this.delegate.setPath(item.getPath());
                this.delegate.setCreationTime(item.getCreationTime());
                this.delegate.setLastModificationTime(item.getLastModificationTime());
                this.delegate.setProperties(item.getProperties());
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
        return item;
    }

    @Override
    public void setDescription(String description) throws InternalErrorException {
        try {
            this.internalDescription(description);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public void rename(String name) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.renameItem(this.getId(), name);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccountingEntry> getAccounting() {
        ArrayList<AccountingEntry> list = new ArrayList<AccountingEntry>();
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            List<AccountingDelegate> accountingNode = servlets.getAccountingById(this.getId());
            for (AccountingDelegate entryNode : accountingNode) {
                try {
                    switch (entryNode.getEntryType()) {
                        case CUT: {
                            list.add(new JCRAccountingFolderEntryCut(entryNode));
                            break;
                        }
                        case PASTE: {
                            list.add(new JCRAccountingEntryPaste(entryNode));
                            break;
                        }
                        case REMOVAL: {
                            list.add(new JCRAccountingFolderEntryRemoval(entryNode));
                            break;
                        }
                        case RENAMING: {
                            list.add(new JCRAccountingEntryRenaming(entryNode));
                            break;
                        }
                        case ADD: {
                            list.add(new JCRAccountingFolderEntryAdd(entryNode));
                            break;
                        }
                        case UPDATE: {
                            list.add(new JCRAccountingEntryUpdate(entryNode));
                            break;
                        }
                        case READ: {
                            list.add(new JCRAccountingEntryRead(entryNode));
                            break;
                        }
                        case SHARE: {
                            list.add(new JCRAccountingEntryShare(entryNode));
                            break;
                        }
                        case UNSHARE: {
                            list.add(new JCRAccountingEntryUnshare(entryNode));
                            break;
                        }
                        case DELETE: {
                            list.add(new JCRAccountingEntryDelete(entryNode));
                            break;
                        }
                        case RESTORE: {
                            list.add(new JCRAccountingEntryRestore(entryNode));
                            break;
                        }
                        case ENABLED_PUBLIC_ACCESS: {
                            list.add(new JCRAccountingEntryEnabledPublicAccess(entryNode));
                            break;
                        }
                        case DISABLED_PUBLIC_ACCESS: {
                            list.add(new JCRAccountingEntryDisabledPublicAccess(entryNode));
                            break;
                        }
                        case SET_ACL: {
                            list.add(new JCRAccountingEntrySetACL(entryNode));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Accounting entry skipped " + entryNode.getEntryType().toString(), (Throwable)e);
                }
            }
            JCRAccountingEntryCreate entry = new JCRAccountingEntryCreate(this.getId(), this.getOwner().getPortalLogin(), this.getCreationTime(), this.delegate.getTitle());
            list.add(entry);
            ArrayList<AccountingEntry> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("Error to retrieve accounting entries ", (Throwable)e);
            ArrayList<AccountingEntry> arrayList = list;
            return arrayList;
        }
        finally {
            servlets.releaseSession();
        }
    }

    @Override
    public JCRAbstractWorkspaceFolder getParent() throws InternalErrorException {
        try {
            return this.workspace.getParent(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public boolean isShared() throws InternalErrorException {
        return this.getType().equals(WorkspaceItemType.SHARED_FOLDER) || this.delegate.getProperties().containsKey((Object)NodeProperty.SHARED_ROOT_ID);
    }

    protected JCRAbstractWorkspaceFolder getParent(ItemDelegate node) throws InternalErrorException {
        try {
            return this.workspace.getParent(node);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
    }

    public boolean isRoot(ItemDelegate delegate) throws RepositoryException, InternalErrorException {
        return this.getParentDelegate() == null;
    }

    public ItemDelegate getParentDelegate() throws InternalErrorException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            if (this.parentDelegate == null) {
                this.parentDelegate = servlets.getItemById(this.delegate.getParentId());
            }
        }
        catch (ItemNotFoundException | RepositoryException e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
        return this.parentDelegate;
    }

    public ItemDelegate getDelegate() throws InternalErrorException {
        return this.delegate;
    }

    @Override
    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        block15: {
            System.out.println("remove");
            String parent = this.delegate.getParentId();
            if (!JCRPrivilegesInfo.canDelete(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath(), false)) {
                throw new InsufficientPrivilegesException("Insufficient privileges to delete the resource " + this.getAbsolutePath());
            }
            JCRLockManager lm = null;
            JCRSession servlets = null;
            try {
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
                lm = servlets.getLockManager();
                if (!lm.isLocked(this.getId())) {
                    lm.lockItem(this.getId());
                    System.out.println("Moving to trash: " + this.delegate.getPath());
                    logger.trace("Moving to trash: " + this.delegate.getPath());
                    this.workspace.moveToTrash(servlets, this);
                    try {
                        JCRAccountingFolderEntryRemoval entry = new JCRAccountingFolderEntryRemoval(parent, this.getOwner().getPortalLogin(), Calendar.getInstance(), this.getType(), this.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)((Object)this)).getFolderItemType() : null, this.getName(), this.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)((Object)this)).getMimeType() : null);
                        entry.save(servlets);
                    }
                    catch (Exception e) {
                        logger.error("Impossible to set Removal Accounting Entry to parent of " + this.delegate.getPath());
                    }
                    break block15;
                }
                throw new InternalErrorException("LockException: Node " + this.getPath() + " locked.");
            }
            catch (RepositoryException e) {
                throw new InternalErrorException(e);
            }
            catch (RemoteBackendException e) {
                throw new InternalErrorException(e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException(e);
            }
            catch (WrongDestinationException e) {
                throw new InternalErrorException(e);
            }
            catch (ItemAlreadyExistException e) {
                throw new InternalErrorException(e);
            }
            catch (WorkspaceFolderNotFoundException e) {
                throw new InternalErrorException(e);
            }
            finally {
                if (lm.isLocked(this.getId())) {
                    lm.unlockItem(this.getId());
                }
                servlets.releaseSession();
            }
        }
    }

    @Override
    public void move(WorkspaceFolder destination) throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.moveItem(this.getId(), destination.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public WorkspaceItem cloneItem(String cloneName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            return this.workspace.cloneItem(this.getId(), cloneName);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException(e);
        }
    }

    public ItemDelegate internalCopy(JCRSession servlets, ItemDelegate nodeFolder, String newName, boolean skipSubgraph) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        String pathNewNode = null;
        try {
            pathNewNode = nodeFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars(newName);
            if (this.workspace.exists(Text.escapeIllegalJcrChars(newName), nodeFolder.getId())) {
                try {
                    WorkspaceFolder destinationFolder = (WorkspaceFolder)((Object)this.workspace.getWorkspaceItem(nodeFolder));
                    newName = destinationFolder.getUniqueName(newName, true);
                    pathNewNode = nodeFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars(newName);
                }
                catch (Exception e) {
                    logger.trace("impossible to convert item in WorkspaceItem");
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        try {
            servlets.copy(this.delegate.getPath(), pathNewNode, skipSubgraph);
            ItemDelegate newNode = servlets.getItemByPath(pathNewNode);
            newNode.setLastModificationTime(Calendar.getInstance());
            newNode.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            newNode.setTitle(Text.unescapeIllegalJcrChars(newName));
            newNode.setLastAction(WorkspaceItemAction.CLONED);
            servlets.saveItem(newNode, false);
            return newNode;
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
    }

    public void internalMove(JCRSession servlets, ItemDelegate destinationFolderNode, String destinationPath) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getId());
            this.delegate = servlets.move(this.delegate.getPath(), destinationFolderNode.getPath() + this.workspace.getPathSeparator() + this.delegate.getName());
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            this.delegate.setLastAction(WorkspaceItemAction.MOVED);
            try {
                this.delegate.getContent().put(NodeProperty.REMOTE_STORAGE_PATH, destinationPath);
            }
            catch (Exception e) {
                try {
                    this.delegate.getProperties().put(NodeProperty.REMOTE_STORAGE_PATH, destinationPath);
                }
                catch (Exception e1) {
                    logger.error("Remote path property is not in " + this.delegate.getPath());
                }
            }
            servlets.saveItem(this.delegate);
        }
        catch (Exception e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException(e);
        }
    }

    public void internalRename(JCRSession servlets, String newName, String remotePath) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars(newName);
        try {
            logger.debug("Internal rename item with id " + this.getId() + " to destination item with id " + this.delegate.getParentId());
            ItemDelegate parent = servlets.getItemById(this.delegate.getParentId());
            String newPath = parent.getPath() + this.workspace.getPathSeparator() + nodeNewName;
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            this.delegate.setLastAction(WorkspaceItemAction.RENAMED);
            try {
                this.delegate.getContent().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            }
            catch (Exception e) {
                logger.debug("remotePath will not be updated for item " + this.delegate.getPath());
            }
            this.delegate.setTitle(nodeNewName);
            try {
                servlets.move(this.delegate.getPath(), newPath);
                servlets.saveItem(this.delegate, false);
            }
            catch (Exception e) {
                logger.error("Impossible to save " + this.delegate.getPath() + ", " + e.toString());
                throw new InternalErrorException(e);
            }
        }
        catch (Exception e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException(e);
        }
    }

    public void internalDescription(String newDescription) throws InternalErrorException {
        Validate.notNull(newDescription, "Description must be not null");
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            this.delegate.setDescription(newDescription);
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            servlets.saveItem(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    @Override
    public boolean isMarkedAsRead() throws InternalErrorException {
        try {
            return this.hasReaders();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasReaders() throws RepositoryException, InternalErrorException {
        JCRSession servlets = null;
        int count = 0;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            List<AccountingDelegate> accounting = servlets.getAccountingById(this.getId());
            for (AccountingDelegate entry : accounting) {
                if (!entry.equals((Object)AccountingEntryType.READ)) continue;
                ++count;
            }
            if (count > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            logger.debug("Node READERS has been added to " + this.delegate.getPath());
            boolean bl = false;
            return bl;
        }
        finally {
            servlets.releaseSession();
        }
        return false;
    }

    @Override
    public List<AccountingEntryRead> getReaders() throws InternalErrorException {
        ArrayList<JCRAccountingEntryRead> list = new ArrayList<JCRAccountingEntryRead>();
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            List<AccountingDelegate> accountingNode = servlets.getAccountingById(this.getId());
            for (AccountingDelegate entry : accountingNode) {
                try {
                    if (!entry.equals((Object)AccountingEntryType.READ)) continue;
                    list.add(new JCRAccountingEntryRead(entry));
                }
                catch (Exception e) {
                    logger.debug("Node ACCOUNTING not found");
                }
            }
            ArrayList<JCRAccountingEntryRead> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public void setShareHistory(JCRSession servlet, List<String> users, String author) throws InternalErrorException {
        try {
            this.setShare(servlet, users, author);
            this.setHistoryShareUnshare(servlet, this, AccountingEntryType.SHARE.getNodeTypeDefinition(), author, users);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
    }

    public void setHistoryShareUnshare(JCRSession servlet, WorkspaceItem item, String operation, String user, List<String> members) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        for (WorkspaceItem workspaceItem : item.getChildren()) {
            try {
                if (workspaceItem.getType().equals(WorkspaceItemType.FOLDER_ITEM) || workspaceItem.getType().equals(WorkspaceItemType.FOLDER)) {
                    if (operation.equals(AccountingEntryType.UNSHARE.getNodeTypeDefinition())) {
                        ((JCRWorkspaceItem)workspaceItem).setUnshare(servlet, user);
                    } else if (operation.equals(AccountingEntryType.SHARE.getNodeTypeDefinition())) {
                        ((JCRWorkspaceItem)workspaceItem).setShare(servlet, members, user);
                    }
                }
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (workspaceItem.getChildren().size() <= 0) continue;
            this.setHistoryShareUnshare(servlet, workspaceItem, operation, user, members);
        }
    }

    public void setUnshareHistory(JCRSession servlets, String user) throws InternalErrorException {
        this.setUnshare(servlets, user);
        try {
            this.setHistoryShareUnshare(servlets, this, AccountingEntryType.UNSHARE.getNodeTypeDefinition(), user, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShare(JCRSession servlets, List<String> users, String author) throws InternalErrorException {
        logger.debug("Add SHARE operation for user " + author + " to node " + this.delegate.getPath());
        try {
            JCRAccountingEntryShare entry = new JCRAccountingEntryShare(this.getId(), author, Calendar.getInstance(), this.getName(), users);
            entry.save(servlets);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
    }

    public void setUnshare(JCRSession servlets, String user) throws InternalErrorException {
        logger.debug("Add UNSHARE operation for user " + user + " on item " + this.delegate.getPath());
        try {
            JCRAccountingEntryUnshare entry = new JCRAccountingEntryUnshare(this.getId(), user, Calendar.getInstance(), this.delegate.getTitle());
            entry.save(servlets);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public void markAsRead(boolean read) throws InternalErrorException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
            logger.debug("Mark Node " + this.delegate.getPath() + " As Read ");
            String user = this.workspace.getOwner().getPortalLogin();
            if (read) {
                logger.debug("Setting " + this.delegate.getTitle() + " as read in " + this.delegate.getPath());
                WorkspaceVersion version = null;
                if (!this.isFolder()) {
                    version = this.workspace.getVersioning().getCurrentVersion(this.getId());
                }
                JCRAccountingEntryRead entry = new JCRAccountingEntryRead(this.getId(), user, Calendar.getInstance(), this.getName(), version.getName());
                entry.save(servlets);
                try {
                    logger.debug("Mark Parent of Node " + this.delegate.getPath() + " As Read ");
                    JCRAccountingEntryRead entryParent = new JCRAccountingEntryRead(this.delegate.getParentId(), user, Calendar.getInstance(), this.delegate.getTitle(), version.getName());
                    entryParent.save(servlets);
                }
                catch (Exception e) {
                    logger.debug("Error setting " + this.delegate.getTitle() + " as read in parent node");
                }
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    @Override
    public String getRemotePath() throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = this.delegate.getContent().get((Object)NodeProperty.REMOTE_STORAGE_PATH);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        return remotePath;
    }

    public void setRemotePath(JCRSession servlets, String remotePath) throws InternalErrorException, RepositoryException {
        try {
            try {
                Map<NodeProperty, String> contentNode = this.delegate.getContent();
                if (contentNode.containsKey((Object)NodeProperty.REMOTE_STORAGE_PATH)) {
                    contentNode.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                }
            }
            catch (Exception e) {
                try {
                    this.delegate.getProperties().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                }
                catch (Exception e1) {
                    throw new InternalErrorException(e1);
                }
            }
            servlets.saveItem(this.delegate, false);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
    }

    public void setRemotePath(String remotePath) throws InternalErrorException, RepositoryException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            try {
                Map<NodeProperty, String> contentNode = this.delegate.getContent();
                if (contentNode.containsKey((Object)NodeProperty.REMOTE_STORAGE_PATH)) {
                    contentNode.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                }
            }
            catch (Exception e) {
                try {
                    this.delegate.getProperties().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                }
                catch (Exception e1) {
                    throw new InternalErrorException(e1);
                }
            }
            servlets.saveItem(this.delegate, false);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public void setOwnerToCurrentUser(WorkspaceItem item) throws Exception {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
            if (item.getType().equals(WorkspaceItemType.FOLDER_ITEM) || item.getType().equals(WorkspaceItemType.FOLDER)) {
                ItemDelegate itemUnshared = servlets.getItemById(item.getId());
                itemUnshared.setOwner(this.workspace.getOwner().getPortalLogin());
                servlets.saveItem(itemUnshared, false);
                logger.debug("Set Owner in Storage to " + this.workspace.getOwner().getPortalLogin() + " in remotepath " + item.getRemotePath());
                if (!item.isFolder()) {
                    this.workspace.getStorage().setMetaInfo("owner", this.workspace.getOwner().getPortalLogin(), item.getRemotePath());
                }
            }
            List<? extends WorkspaceItem> children = null;
            try {
                children = item.getChildren();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (children != null) {
                for (WorkspaceItem workspaceItem : children) {
                    this.setOwnerToCurrentUser(workspaceItem);
                }
            }
        }
        catch (InternalErrorException e1) {
            throw new InternalErrorException(e1);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public List<String> getUsers() throws InternalErrorException {
        Map users = (Map)new XStream().fromXML(this.delegate.getProperties().get((Object)NodeProperty.USERS));
        return new ArrayList<String>(users.keySet());
    }

    @Override
    public boolean isFolder() throws InternalErrorException {
        return this.getType().equals(WorkspaceItemType.FOLDER) || this.getType().equals(WorkspaceItemType.SHARED_FOLDER);
    }

    @Override
    public String getPublicLink(boolean shortenUrl) throws InternalErrorException {
        logger.debug("get PublicLink for item: " + this.getName());
        String publicLink = null;
        if (this.getType().equals(WorkspaceItemType.FOLDER_ITEM)) {
            try {
                publicLink = this.workspace.getStorage().getPublicLink(this.getRemotePath());
            }
            catch (Exception e) {
                throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
            }
        } else {
            logger.warn("ItemId: " + this.getId() + " is not a folder item, Public Link unavailable");
            throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
        }
        if (shortenUrl) {
            try {
                return this.getShortUrl(publicLink);
            }
            catch (Exception e) {
                logger.error("Impossible to get short url. Long url will be returned.");
            }
        }
        return publicLink;
    }

    public String getShortUrl(String longUrl) throws Exception {
        logger.trace("get short url for " + longUrl);
        UrlShortener shortener = new UrlShortener();
        try {
            if (shortener != null && shortener.isAvailable()) {
                return shortener.shorten(longUrl);
            }
            return longUrl;
        }
        catch (Exception e) {
            logger.error("Error get short url for ", (Throwable)e);
            return longUrl;
        }
    }

    @Override
    public boolean isTrashed() throws InternalErrorException {
        return this.getPath().startsWith("/Trash/");
    }

    public String getAbsolutePath() throws InternalErrorException {
        logger.trace("Getting absolute path of: " + this.delegate.getTitle());
        JCRSession servlets = null;
        String path = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            ItemDelegate node = servlets.getItemById(this.getId());
            path = node.getPath();
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
        return path;
    }

    @Override
    public boolean hasAccessRight(String user, String absPath) throws InternalErrorException {
        List<String> privileges;
        Map<String, List<String>> map;
        JCRAccessManager accessManager = new JCRAccessManager();
        try {
            map = accessManager.getDeniedMap(absPath);
        }
        catch (Exception e) {
            throw new InternalErrorException("Impossible to retrieve privileges");
        }
        return !map.containsKey(user) || !(privileges = map.get(user)).contains("jcr:read");
    }

    @Override
    public void deleteACL(List<String> users) throws InternalErrorException {
        logger.trace("Remove ACL for users " + users.toString() + " on item " + this.getAbsolutePath());
        String absPath = null;
        JCRAccessManager accessManager = new JCRAccessManager();
        try {
            absPath = this.getAbsolutePath();
            accessManager.deleteAces(absPath, users);
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
    }

    @Override
    public String getLastUpdatedBy() throws InternalErrorException {
        List<AccountingEntry> accounting = null;
        String updatedBy = null;
        try {
            accounting = this.getAccounting();
            int size = accounting.size();
            if (size > 0) {
                updatedBy = accounting.get(size - 1).getUser();
            }
        }
        catch (Exception e) {
            throw new InternalErrorException("Impossible to retrieve Last Updated By");
        }
        return updatedBy;
    }

    @Override
    public ACLType getACLUser() throws InternalErrorException {
        return this.getACLByUser(this.workspace.getOwner().getPortalLogin());
    }

    public ACLType getACLByUser(String user) throws InternalErrorException {
        return JCRPrivilegesInfo.getACLByUser(user, this.getAbsolutePath());
    }

    @Override
    public Map<ACLType, List<String>> getACLOwner() throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = null;
        Map<String, List<String>> aclMap = null;
        HashMap<ACLType, List<String>> map = new HashMap<ACLType, List<String>>();
        try {
            accessManager = new JCRAccessManager();
            absPath = this.getAbsolutePath();
            aclMap = accessManager.getACL(absPath, this.workspace.getOwner().getPortalLogin());
            Set<String> keys = aclMap.keySet();
            for (final String user : keys) {
                JCRUserManager um = new JCRUserManager();
                GCubeGroup group = null;
                try {
                    group = um.getGroup(user);
                    if (group != null && group.getMembers().isEmpty()) continue;
                    ACLType aclType = WorkspaceUtil.getACLTypeByKey(aclMap.get(user));
                    List users = null;
                    try {
                        users = (List)map.get((Object)aclType);
                        users.add(user);
                        map.put(aclType, users);
                    }
                    catch (Exception e) {
                        map.put(aclType, (List<String>)new ArrayList<String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.add(user);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        return map;
    }

    @Override
    public void setHidden(boolean flag) throws InternalErrorException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            this.delegate.setHidden(flag);
            servlets.saveItem(this.delegate, false);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException(e);
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    @Override
    public boolean isHidden() throws InternalErrorException {
        return this.delegate.isHidden();
    }

    @Override
    public void updateItem(InputStream fileData) throws InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException {
        try {
            this.workspace.updateItem(this.getId(), fileData);
        }
        catch (ItemAlreadyExistException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public String getStorageID() throws InternalErrorException {
        logger.info("get Storage ID for item: " + this.getName());
        String storageId = null;
        try {
            storageId = this.getDelegate().getContent().get((Object)NodeProperty.STORAGE_ID);
        }
        catch (Exception e) {
            throw new InternalErrorException("Sorry, Storage ID for selected file is unavailable");
        }
        return storageId;
    }
}

