/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.configuration;

import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import org.gcube.accounting.aggregator.configuration.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementFileBackup {
    private static Logger logger = LoggerFactory.getLogger(ManagementFileBackup.class);
    private static ManagementFileBackup instance;

    private ManagementFileBackup() {
        File DirDel;
        File DirIns = new File(Constant.PATH_DIR_BACKUP_INSERT);
        if (!DirIns.exists()) {
            DirIns.mkdir();
        }
        if (!(DirDel = new File(Constant.PATH_DIR_BACKUP_DELETE)).exists()) {
            DirDel.mkdir();
        }
    }

    public static ManagementFileBackup getInstance() {
        if (instance == null) {
            instance = new ManagementFileBackup();
        }
        return instance;
    }

    public boolean onCreateStringToFile(List<JsonDocument> listJson, String nameFile, Boolean type) {
        try {
            File file = type != false ? new File(Constant.PATH_DIR_BACKUP_INSERT + "/" + nameFile.replace(",", "_")) : new File(Constant.PATH_DIR_BACKUP_DELETE + "/" + nameFile.replace(",", "_"));
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(file, true));
            writer.write("{\"new_edits\":false,\"docs\":[");
            writer.newLine();
            int count = 1;
            for (JsonDocument row : listJson) {
                if (count == listJson.size()) {
                    writer.write(((JsonObject)row.content()).toString());
                } else {
                    writer.write(((JsonObject)row.content()).toString() + ",");
                }
                writer.newLine();
                ++count;
            }
            writer.write("]}");
            writer.newLine();
            writer.close();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public boolean onDeleteFile(String nameFile, Boolean type) {
        try {
            File file = type != false ? new File(Constant.PATH_DIR_BACKUP_INSERT + "/" + nameFile.replace(",", "_")) : new File(Constant.PATH_DIR_BACKUP_DELETE + "/" + nameFile.replace(",", "_"));
            file.delete();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

