/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query.qom;

import javax.jcr.query.qom.FullTextSearch;
import org.apache.jackrabbit.oak.jcr.query.qom.ConstraintImpl;
import org.apache.jackrabbit.oak.jcr.query.qom.QueryObjectModelImpl;
import org.apache.jackrabbit.oak.jcr.query.qom.StaticOperandImpl;

public class FullTextSearchImpl
extends ConstraintImpl
implements FullTextSearch {
    private final String selectorName;
    private final String propertyName;
    private final StaticOperandImpl fullTextSearchExpression;

    public FullTextSearchImpl(String selectorName, String propertyName, StaticOperandImpl fullTextSearchExpression) {
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.fullTextSearchExpression = fullTextSearchExpression;
    }

    @Override
    public StaticOperandImpl getFullTextSearchExpression() {
        return this.fullTextSearchExpression;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getSelectorName() {
        return this.selectorName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CONTAINS(");
        if (this.selectorName != null) {
            builder.append(this.quoteSelectorName(this.selectorName));
            builder.append('.');
        }
        if (this.propertyName != null) {
            builder.append(this.quotePropertyName(this.propertyName));
        } else {
            builder.append('*');
        }
        builder.append(", ");
        builder.append(this.getFullTextSearchExpression());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void bindVariables(QueryObjectModelImpl qom) {
        this.fullTextSearchExpression.bindVariables(qom);
    }
}

