/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import java.security.Principal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.security.user.AuthorizableBaseProvider;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableNodeName;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserProvider
extends AuthorizableBaseProvider {
    private static final Logger log = LoggerFactory.getLogger(UserProvider.class);
    private static final String DELIMITER = "/";
    private final int defaultDepth;
    private final String groupPath;
    private final String userPath;

    UserProvider(Root root, ConfigurationParameters config) {
        super(root, config);
        this.defaultDepth = config.getConfigValue("defaultDepth", 2);
        this.groupPath = config.getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
        this.userPath = config.getConfigValue("usersPath", "/rep:security/rep:authorizables/rep:users");
    }

    @Nonnull
    Tree createUser(String userID, String intermediateJcrPath) throws RepositoryException {
        return this.createAuthorizableNode(userID, false, intermediateJcrPath);
    }

    @Nonnull
    Tree createGroup(String groupID, String intermediateJcrPath) throws RepositoryException {
        return this.createAuthorizableNode(groupID, true, intermediateJcrPath);
    }

    @CheckForNull
    Tree getAuthorizable(String authorizableId) {
        return this.getByID(authorizableId, AuthorizableType.AUTHORIZABLE);
    }

    @CheckForNull
    Tree getAuthorizableByPath(String authorizableOakPath) {
        return this.getByPath(authorizableOakPath);
    }

    @CheckForNull
    Tree getAuthorizableByPrincipal(Principal principal) {
        if (principal instanceof TreeBasedPrincipal) {
            return this.root.getTree(((TreeBasedPrincipal)principal).getOakPath());
        }
        try {
            StringBuilder stmt = new StringBuilder();
            stmt.append("SELECT * FROM [").append("rep:Authorizable").append(']');
            stmt.append("WHERE [").append("rep:principalName").append("] = $principalName");
            Result result = this.root.getQueryEngine().executeQuery(stmt.toString(), "JCR-SQL2", 1L, 0L, Collections.singletonMap("principalName", PropertyValues.newString(principal.getName())), QueryEngine.NO_MAPPINGS);
            Iterator<? extends ResultRow> rows = result.getRows().iterator();
            if (rows.hasNext()) {
                String path = rows.next().getPath();
                return this.root.getTree(path);
            }
        }
        catch (ParseException ex) {
            log.error("Failed to retrieve authorizable by principal", (Throwable)ex);
        }
        return null;
    }

    private Tree createAuthorizableNode(String authorizableId, boolean isGroup, String intermediatePath) throws RepositoryException {
        String nodeName = this.getNodeName(authorizableId);
        NodeUtil folder = this.createFolderNodes(authorizableId, nodeName, isGroup, intermediatePath);
        String ntName = isGroup ? "rep:Group" : "rep:User";
        NodeUtil authorizableNode = folder.addChild(nodeName, ntName);
        String nodeID = UserProvider.getContentID(authorizableId);
        authorizableNode.setString("rep:authorizableId", authorizableId);
        authorizableNode.setString("jcr:uuid", nodeID);
        return authorizableNode.getTree();
    }

    private NodeUtil createFolderNodes(String authorizableId, String nodeName, boolean isGroup, String intermediatePath) throws RepositoryException {
        NodeUtil folder;
        String authRoot = isGroup ? this.groupPath : this.userPath;
        String folderPath = authRoot + this.getFolderPath(authorizableId, intermediatePath, authRoot);
        Tree tree = this.root.getTree(folderPath);
        while (!tree.isRoot() && !tree.exists()) {
            tree = tree.getParent();
        }
        if (tree.exists()) {
            folder = new NodeUtil(tree);
            String relativePath = PathUtils.relativize(tree.getPath(), folderPath);
            if (!relativePath.isEmpty()) {
                folder = folder.getOrAddTree(relativePath, "rep:AuthorizableFolder");
            }
        } else {
            throw new AccessDeniedException("Missing permission to create intermediate authorizable folders.");
        }
        while (folder.hasChild(nodeName)) {
            NodeUtil colliding = folder.getChild(nodeName);
            String primaryType = TreeUtil.getPrimaryTypeName(colliding.getTree());
            if ("rep:AuthorizableFolder".equals(primaryType)) {
                log.debug("Existing folder node collides with user/group to be created. Expanding path by: " + colliding.getName());
                folder = colliding;
                continue;
            }
            String msg = "Failed to create authorizable with id '" + authorizableId + "' : " + "Detected conflicting node of unexpected node type '" + primaryType + "'.";
            log.error(msg);
            throw new ConstraintViolationException(msg);
        }
        return folder;
    }

    private String getFolderPath(String authorizableId, String intermediatePath, String authRoot) throws ConstraintViolationException {
        if (intermediatePath != null && intermediatePath.charAt(0) == '/') {
            if (!intermediatePath.startsWith(authRoot)) {
                throw new ConstraintViolationException("Attempt to create authorizable outside of configured tree");
            }
            intermediatePath = intermediatePath.substring(authRoot.length() + 1);
        }
        StringBuilder sb = new StringBuilder();
        if (intermediatePath != null && !intermediatePath.isEmpty()) {
            sb.append(DELIMITER).append(intermediatePath);
        } else {
            int idLength = authorizableId.length();
            StringBuilder segment = new StringBuilder();
            for (int i = 0; i < this.defaultDepth; ++i) {
                if (idLength > i) {
                    segment.append(authorizableId.charAt(i));
                } else {
                    segment.append(authorizableId.charAt(idLength - 1));
                }
                sb.append(DELIMITER).append(Text.escapeIllegalJcrChars(segment.toString()));
            }
        }
        return sb.toString();
    }

    private String getNodeName(String authorizableId) {
        AuthorizableNodeName generator = Preconditions.checkNotNull(this.config.getConfigValue("authorizableNodeName", AuthorizableNodeName.DEFAULT, AuthorizableNodeName.class));
        return generator.generateNodeName(authorizableId);
    }
}

