/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import com.google.common.collect.ImmutableSet;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.namepath.LocalNameMapper;
import org.apache.jackrabbit.oak.namepath.NamePathMapperImpl;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.SQL2Parser;
import org.apache.jackrabbit.oak.query.xpath.XPathToSQL2Converter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryEngineImpl
implements QueryEngine {
    static final String SQL2 = "JCR-SQL2";
    static final String SQL = "sql";
    static final String XPATH = "xpath";
    static final String JQOM = "JCR-JQOM";
    static final String NO_LITERALS = "-noLiterals";
    static final Logger LOG = LoggerFactory.getLogger(QueryEngineImpl.class);
    private static final Set<String> SUPPORTED_LANGUAGES = ImmutableSet.of("JCR-SQL2", "JCR-SQL2-noLiterals", "sql", "sql-noLiterals", "xpath", "xpath-noLiterals", new String[]{"JCR-JQOM"});
    private boolean traversalEnabled = true;

    protected abstract ExecutionContext getExecutionContext();

    @Override
    public Set<String> getSupportedQueryLanguages() {
        return SUPPORTED_LANGUAGES;
    }

    @Override
    public List<String> getBindVariableNames(String statement, String language, Map<String, String> mappings) throws ParseException {
        Query q = QueryEngineImpl.parseQuery(statement, language, this.getExecutionContext(), mappings);
        return q.getBindVariableNames();
    }

    private static Query parseQuery(String statement, String language, ExecutionContext context, Map<String, String> mappings) throws ParseException {
        LOG.debug("Parsing {} statement: {}", (Object)language, (Object)statement);
        NamePathMapperImpl mapper = new NamePathMapperImpl(new LocalNameMapper(context.getRoot(), mappings));
        NodeState types = context.getBaseState().getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
        QueryEngineSettings settings = context.getSettings();
        SQL2Parser parser = new SQL2Parser(mapper, types, settings);
        if (language.endsWith(NO_LITERALS)) {
            language = language.substring(0, language.length() - NO_LITERALS.length());
            parser.setAllowNumberLiterals(false);
            parser.setAllowTextLiterals(false);
        }
        if (SQL2.equals(language) || JQOM.equals(language)) {
            return parser.parse(statement);
        }
        if (SQL.equals(language)) {
            parser.setSupportSQL1(true);
            return parser.parse(statement);
        }
        if (XPATH.equals(language)) {
            XPathToSQL2Converter converter = new XPathToSQL2Converter();
            String sql2 = converter.convert(statement);
            LOG.debug("XPath > SQL2: {}", (Object)sql2);
            try {
                parser.setIncludeSelectorNameInWildcardColumns(false);
                return parser.parse(sql2);
            }
            catch (ParseException e) {
                ParseException e2 = new ParseException(statement + " converted to SQL-2 " + e.getMessage(), 0);
                e2.initCause(e);
                throw e2;
            }
        }
        throw new ParseException("Unsupported language: " + language, 0);
    }

    @Override
    public Result executeQuery(String statement, String language, long limit, long offset, Map<String, ? extends PropertyValue> bindings, Map<String, String> mappings) throws ParseException {
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit may not be negative, is: " + limit);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset may not be negative, is: " + offset);
        }
        if (bindings == null) {
            bindings = NO_BINDINGS;
        }
        if (mappings == null) {
            mappings = NO_MAPPINGS;
        }
        ExecutionContext context = this.getExecutionContext();
        Query q = QueryEngineImpl.parseQuery(statement, language, context, mappings);
        q.setExecutionContext(context);
        q.setLimit(limit);
        q.setOffset(offset);
        if (bindings != null) {
            for (Map.Entry e : bindings.entrySet()) {
                q.bindValue((String)e.getKey(), (PropertyValue)e.getValue());
            }
        }
        q.setTraversalEnabled(this.traversalEnabled);
        q.prepare();
        return q.executeQuery();
    }

    protected void setTraversalEnabled(boolean traversalEnabled) {
        this.traversalEnabled = traversalEnabled;
    }
}

