/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class PropertyPredicate
implements Predicate<NodeState> {
    private final String name;
    private final Predicate<PropertyState> propertyPredicate;

    public PropertyPredicate(@Nonnull String name, @Nonnull Predicate<PropertyState> propertyPredicate) {
        this.name = Preconditions.checkNotNull(name);
        this.propertyPredicate = Preconditions.checkNotNull(propertyPredicate);
    }

    @Override
    public boolean apply(NodeState node) {
        PropertyState property = node.getProperty(this.name);
        return property != null && this.propertyPredicate.apply(property);
    }
}

