/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.version.LabelExistsVersionException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionManagerDelegate;

public class VersionHistoryDelegate
extends NodeDelegate {
    VersionHistoryDelegate(@Nonnull SessionDelegate sessionDelegate, @Nonnull Tree vhTree) {
        super(sessionDelegate, Preconditions.checkNotNull(vhTree));
    }

    public String getVersionableIdentifier() throws InvalidItemStateException {
        return this.getTree().getProperty("jcr:versionableUuid").getValue(Type.STRING);
    }

    @Nonnull
    public VersionDelegate getRootVersion() throws RepositoryException {
        Tree rootVersion = this.getTree().getChild("jcr:rootVersion");
        if (!rootVersion.exists()) {
            throw new RepositoryException("Inconsistent version storage. VersionHistory does not have a root version");
        }
        return VersionDelegate.create(this.sessionDelegate, rootVersion);
    }

    @Nonnull
    public VersionDelegate getVersion(@Nonnull String versionName) throws VersionException, RepositoryException {
        Preconditions.checkNotNull(versionName);
        Tree version = this.getTree().getChild(versionName);
        if (!version.exists()) {
            throw new VersionException("No such Version: " + versionName);
        }
        return VersionDelegate.create(this.sessionDelegate, version);
    }

    @Nonnull
    public VersionDelegate getVersionByLabel(@Nonnull String label) throws VersionException, RepositoryException {
        Preconditions.checkNotNull(label);
        Tree versionLabels = this.getVersionLabelsTree();
        PropertyState p = versionLabels.getProperty(label);
        if (p == null) {
            throw new VersionException("Unknown label: " + label);
        }
        String id = p.getValue(Type.REFERENCE);
        Tree version = this.sessionDelegate.getIdManager().getTree(id);
        if (version == null || !version.exists()) {
            throw new VersionException("Invalid label: " + label + '(' + id + ')');
        }
        return VersionDelegate.create(this.sessionDelegate, version);
    }

    @Nonnull
    public Iterable<String> getVersionLabels() throws RepositoryException {
        Tree versionLabels = this.getVersionLabelsTree();
        ArrayList<String> labels = new ArrayList<String>();
        for (PropertyState propertyState : versionLabels.getProperties()) {
            if (propertyState.getType() != Type.REFERENCE) continue;
            labels.add(propertyState.getName());
        }
        return labels;
    }

    @Nonnull
    public Iterable<String> getVersionLabels(@Nonnull String identifier) throws RepositoryException {
        Preconditions.checkNotNull(identifier);
        Tree versionLabels = this.getVersionLabelsTree();
        ArrayList<String> labels = new ArrayList<String>();
        for (PropertyState propertyState : versionLabels.getProperties()) {
            if (propertyState.getType() != Type.REFERENCE || !identifier.equals(propertyState.getValue(Type.REFERENCE))) continue;
            labels.add(propertyState.getName());
        }
        return labels;
    }

    @Nonnull
    public Iterator<VersionDelegate> getAllVersions() throws RepositoryException {
        ArrayList<NodeDelegate> versions = new ArrayList<NodeDelegate>();
        Iterator<NodeDelegate> it = this.getChildren();
        while (it.hasNext()) {
            NodeDelegate n = it.next();
            String primaryType = n.getProperty("jcr:primaryType").getString();
            if (!primaryType.equals("nt:version")) continue;
            versions.add(n);
        }
        Collections.sort(versions, new Comparator<NodeDelegate>(){

            @Override
            public int compare(NodeDelegate n1, NodeDelegate n2) {
                try {
                    PropertyDelegate c1 = n1.getPropertyOrNull("jcr:created");
                    PropertyDelegate c2 = n2.getPropertyOrNull("jcr:created");
                    if (c1 != null && c2 != null) {
                        return c1.getDate().compareTo(c2.getDate());
                    }
                    if (c1 != null) {
                        return 1;
                    }
                    if (c2 != null) {
                        return -1;
                    }
                    return 0;
                }
                catch (RepositoryException ex) {
                    return 0;
                }
            }
        });
        final Tree thisTree = this.getTree();
        return Iterators.transform(versions.iterator(), new Function<NodeDelegate, VersionDelegate>(){

            @Override
            public VersionDelegate apply(NodeDelegate nd) {
                return VersionDelegate.create(VersionHistoryDelegate.this.sessionDelegate, thisTree.getChild(nd.getName()));
            }
        });
    }

    @Nonnull
    public Iterator<VersionDelegate> getAllLinearVersions() throws RepositoryException {
        String id = this.getVersionableIdentifier();
        NodeDelegate versionable = this.sessionDelegate.getNodeByIdentifier(id);
        if (versionable == null || versionable.getPropertyOrNull("jcr:baseVersion") == null) {
            return Iterators.emptyIterator();
        }
        ArrayDeque<VersionDelegate> linearVersions = new ArrayDeque<VersionDelegate>();
        VersionManagerDelegate vMgr = VersionManagerDelegate.create(this.sessionDelegate);
        for (VersionDelegate version = vMgr.getVersionByIdentifier(versionable.getProperty("jcr:baseVersion").getString()); version != null; version = version.getLinearPredecessor()) {
            linearVersions.add(version);
        }
        return linearVersions.descendingIterator();
    }

    public void addVersionLabel(@Nonnull VersionDelegate version, @Nonnull String oakVersionLabel, boolean moveLabel) throws LabelExistsVersionException, VersionException, RepositoryException {
        VersionManagerDelegate vMgr = VersionManagerDelegate.create(this.sessionDelegate);
        vMgr.addVersionLabel(this, version, oakVersionLabel, moveLabel);
    }

    public void removeVersionLabel(@Nonnull String oakVersionLabel) throws VersionException, RepositoryException {
        VersionManagerDelegate vMgr = VersionManagerDelegate.create(this.sessionDelegate);
        vMgr.removeVersionLabel(this, oakVersionLabel);
    }

    public void removeVersion(@Nonnull String oakVersionName) throws RepositoryException {
        VersionManagerDelegate vMgr = VersionManagerDelegate.create(this.sessionDelegate);
        vMgr.removeVersion(this, oakVersionName);
    }

    @Nonnull
    private Tree getVersionLabelsTree() throws RepositoryException {
        Tree versionLabels = this.getTree().getChild("jcr:versionLabels");
        if (!versionLabels.exists()) {
            throw new RepositoryException("Inconsistent version storage. VersionHistory does not have jcr:versionLabels child node");
        }
        return versionLabels;
    }
}

