/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.usermanager;

import com.thoughtworks.xstream.XStream;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRGroup
implements GCubeGroup {
    private Logger logger = LoggerFactory.getLogger(JCRGroup.class);
    Map<String, GCoreEndpoint.Profile.Endpoint> servlets;
    public String name;
    public Group group;

    public JCRGroup(String name) throws InternalErrorException {
        this.name = name;
        this.servlets = JCRRepository.servlets;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean removeMembers(List<String> usersList) throws InternalErrorException {
        try {
            this.updateGroup(null, usersList);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean addMembers(List<String> users) throws InternalErrorException {
        try {
            this.updateGroup(users, null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean addMember(final String user) throws InternalErrorException {
        try {
            this.updateGroup((List<String>)new ArrayList<String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add(user);
                }
            }, null);
        }
        catch (InternalErrorException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean removeMember(final String user) throws InternalErrorException {
        try {
            this.updateGroup(null, (List<String>)new ArrayList<String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add(user);
                }
            });
        }
        catch (InternalErrorException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isMember(String member) throws InternalErrorException {
        try {
            List<String> members = this.getMembers();
            if (members.contains(member)) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException(e);
        }
        return false;
    }

    @Override
    public List<String> getMembers() throws InternalErrorException {
        HttpMethodBase getMethod = null;
        List users = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("GroupMembershipServlet").uri().toString() + "?groupName=" + this.name);
            TokenUtility.setHeader((GetMethod)getMethod);
            httpClient.executeMethod(getMethod);
            XStream xstream = new XStream();
            users = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return users;
    }

    public void updateGroup(List<String> members, List<String> membersToDelete) throws InternalErrorException {
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            StringBuilder listMembers = null;
            if (members != null) {
                listMembers = new StringBuilder();
                for (String member : members) {
                    listMembers.append("&member=");
                    listMembers.append(member);
                }
            }
            if (membersToDelete != null) {
                listMembers = new StringBuilder();
                for (String member : membersToDelete) {
                    listMembers.append("&memberToDelete=");
                    listMembers.append(member);
                }
            }
            getMethod = new GetMethod(this.servlets.get("UpdateGroupServlet").uri().toString() + "?groupName=" + this.name + listMembers);
            TokenUtility.setHeader((GetMethod)getMethod);
            httpClient.executeMethod(getMethod);
        }
        catch (Exception e) {
            this.logger.error("Error updating Group " + this.name, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    @Override
    public String getDisplayName() throws InternalErrorException {
        String displayName;
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("GetDisplayNameServlet").uri().toString() + "?groupName=" + this.name);
            TokenUtility.setHeader((GetMethod)getMethod);
            httpClient.executeMethod(getMethod);
            XStream xstream = new XStream();
            displayName = (String)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return displayName;
    }

    @Override
    public boolean setDisplayName(String displayName) throws InternalErrorException {
        boolean flag = false;
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("SetDisplayNameServlet").uri().toString() + "?groupName=" + this.name + "&displayName=" + displayName);
            TokenUtility.setHeader((GetMethod)getMethod);
            httpClient.executeMethod(getMethod);
            XStream xstream = new XStream();
            flag = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return flag;
    }
}

