/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;

public class SegmentIdTable {
    private final ArrayList<WeakReference<SegmentId>> references = Lists.newArrayList(Collections.nCopies(1024, null));
    private final SegmentTracker tracker;

    SegmentIdTable(SegmentTracker tracker) {
        this.tracker = tracker;
    }

    synchronized SegmentId getSegmentId(long msb, long lsb) {
        SegmentId id;
        int first;
        int index = first = this.getIndex(lsb);
        WeakReference<SegmentId> reference = this.references.get(index);
        while (reference != null) {
            id = (SegmentId)reference.get();
            if (id != null && id.getMostSignificantBits() == msb && id.getLeastSignificantBits() == lsb) {
                return id;
            }
            index = (index + 1) % this.references.size();
            reference = this.references.get(index);
        }
        id = new SegmentId(this.tracker, msb, lsb);
        this.references.set(index, new WeakReference<SegmentId>(id));
        if (index != first) {
            this.refresh();
        }
        return id;
    }

    void collectReferencedIds(Collection<SegmentId> ids) {
        ids.addAll(this.refresh());
    }

    private synchronized Collection<SegmentId> refresh() {
        int size = this.references.size();
        HashMap<SegmentId, WeakReference<SegmentId>> ids = Maps.newHashMapWithExpectedSize(size);
        boolean hashCollisions = false;
        boolean emptyReferences = false;
        for (int i = 0; i < size; ++i) {
            WeakReference<SegmentId> reference = this.references.get(i);
            if (reference == null) continue;
            SegmentId id = (SegmentId)reference.get();
            if (id != null) {
                ids.put(id, reference);
                hashCollisions = hashCollisions || i != this.getIndex(id);
                continue;
            }
            this.references.set(i, null);
            emptyReferences = true;
        }
        while (2 * ids.size() > size) {
            size *= 2;
        }
        if (hashCollisions && emptyReferences || size != this.references.size()) {
            this.references.clear();
            this.references.addAll(Collections.nCopies(size, null));
            for (Map.Entry entry : ids.entrySet()) {
                int index = this.getIndex((SegmentId)entry.getKey());
                while (this.references.get(index) != null) {
                    index = (index + 1) % size;
                }
                this.references.set(index, (WeakReference<SegmentId>)entry.getValue());
            }
        }
        return ids.keySet();
    }

    private int getIndex(SegmentId id) {
        return this.getIndex(id.getLeastSignificantBits());
    }

    private int getIndex(long lsb) {
        return (int)lsb & this.references.size() - 1;
    }
}

