/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.lock;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.NodeOperation;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

public final class LockImpl
implements Lock {
    private final SessionContext context;
    private final NodeDelegate delegate;

    public LockImpl(@Nonnull SessionContext context, @Nonnull NodeDelegate delegate) {
        this.context = Preconditions.checkNotNull(context);
        this.delegate = Preconditions.checkNotNull(delegate);
    }

    @Override
    public Node getNode() {
        try {
            return NodeImpl.createNode(this.delegate, this.context);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to access the lock node", e);
        }
    }

    @Override
    public String getLockOwner() {
        return this.safePerform(new NodeOperation<String>(this.delegate, "getLockOwner"){

            @Override
            public String perform() {
                return this.node.getLockOwner();
            }
        });
    }

    @Override
    public boolean isDeep() {
        return this.safePerform(new NodeOperation<Boolean>(this.delegate, "isDeep"){

            @Override
            public Boolean perform() {
                return this.node.holdsLock(true);
            }
        });
    }

    @Override
    public boolean isLive() {
        return this.context.getSession().isLive() && this.safePerform(new NodeOperation<Boolean>(this.delegate, "isLive"){

            @Override
            public Boolean perform() {
                return this.node.holdsLock(false);
            }
        }) != false;
    }

    @Override
    public String getLockToken() {
        return this.safePerform(new NodeOperation<String>(this.delegate, "getLockToken"){

            @Override
            public String perform() {
                String token = this.node.getPath();
                if (LockImpl.this.context.getOpenScopedLocks().contains(token)) {
                    return token;
                }
                if (LockImpl.this.context.getSessionScopedLocks().contains(token)) {
                    return null;
                }
                if (this.node.isLockOwner(LockImpl.this.context.getSessionDelegate().getAuthInfo().getUserID())) {
                    return token;
                }
                return null;
            }
        });
    }

    @Override
    public long getSecondsRemaining() {
        if (this.isLive()) {
            return Long.MAX_VALUE;
        }
        return -1L;
    }

    @Override
    public boolean isSessionScoped() {
        return this.safePerform(new NodeOperation<Boolean>(this.delegate, "isSessionScoped"){

            @Override
            public Boolean perform() {
                String path = this.node.getPath();
                return LockImpl.this.context.getSessionScopedLocks().contains(path);
            }
        });
    }

    @Override
    public boolean isLockOwningSession() {
        return this.safePerform(new NodeOperation<Boolean>(this.delegate, "isLockOwningSessions"){

            @Override
            public Boolean perform() {
                String path = this.node.getPath();
                return LockImpl.this.context.getSessionScopedLocks().contains(path) || LockImpl.this.context.getOpenScopedLocks().contains(path);
            }
        });
    }

    @Override
    public void refresh() throws LockException {
        if (!this.isLive()) {
            throw new LockException("This lock is not alive");
        }
    }

    @CheckForNull
    private final <U> U safePerform(@Nonnull SessionOperation<U> op) {
        return this.context.getSessionDelegate().safePerform(op);
    }
}

