/**
 * 
 */
package org.gcube.portlets.user.tdcolumnoperation.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.SplitColumnMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class SplitColumnProgressUpdater extends Timer {

	protected ArrayList<SplitColumnProgressListener> listeners = new ArrayList<SplitColumnProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getSplitColumnMonitor(new AsyncCallback<SplitColumnMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(SplitColumnMonitor result) {
						Log.info("retrieved SplitColumnMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationValidate(result.getProgress());
							break;	
						case GENERATING_VIEW:
							Log.info("Generating View...");
							fireOperationGeneratingView();
							break;		
						case STOPPED:
							cancel();
							stopMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Fisnish :"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(SplitColumnMonitor result) {
		Log.info("Split Column Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library Split Column";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library Split Columnn";
			details = "Split Column failed";
		}
		
		fireOperationFailed(th, failure, details);
	}
	
	protected void stopMessage(SplitColumnMonitor result) {
		Log.info("Split Column Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped split column";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped split column";
			details = "Split Column stopped";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (SplitColumnProgressListener listener : listeners)
			listener.operationInitializing();
	}
	
	protected void fireOperationGeneratingView() {
		for (SplitColumnProgressListener listener : listeners)
			listener.operationGeneratingView();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (SplitColumnProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}
	
	protected void fireOperationValidate(float elaborated) {
		for (SplitColumnProgressListener listener : listeners)
			listener.operationValidate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (SplitColumnProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (SplitColumnProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}

	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (SplitColumnProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	
	
	/**
	 * Add a new {@link SplitColumnProgressListener} to this
	 * {@link SplitColumnProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(SplitColumnProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link SplitColumnProgressListener} from this
	 * {@link SplitColumnProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(SplitColumnProgressListener listener) {
		listeners.remove(listener);
	}
}
