/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.javax.filters;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;

import org.fao.fi.security.common.utilities.LoggingClient;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 12 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 12 May 2014
 */
abstract public class AbstractFilter extends LoggingClient {
	static final public String FILTER_DEBUG_SYSTEM_PROPERTY = "fi.security.server.filter.debug";
	
	protected abstract String getSecurityScheme();
	
	protected Response errorResponse(Response.Status status, String message) {
		ResponseBuilder responseBuilder = Response.status(status);
		
		if(Boolean.TRUE.equals(Boolean.getBoolean(FILTER_DEBUG_SYSTEM_PROPERTY)))
			responseBuilder.header(FilterConstants.SECURED_WITH_HEADER, this.getSecurityScheme());
		
		return responseBuilder.entity(message).build();
	}
}