/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.server.providers.validators.token.impl;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.fao.fi.security.server.providers.validators.token.impl.configuration.TokenManagerSimpleConfiguration;
import org.fao.fi.security.server.providers.validators.token.spi.AbstractTokenManager;
import org.fao.fi.security.server.providers.validators.token.spi.TokenManagerConfigurator;

@Singleton
public class LocalTokenManager
extends AbstractTokenManager
implements CacheEventListener {
    protected static final String TOKEN_CACHE_ID = "token.cache";
    protected static final int TOKEN_CACHE_SIZE = 10000;
    protected static final int TOKEN_EXPIRATION_TIME = 5;
    protected TokenManagerConfigurator _configuration;
    protected CacheManager _cacheManager;
    protected Cache _tokenCache;

    public LocalTokenManager() {
    }

    @Inject
    public LocalTokenManager(TokenManagerConfigurator configuration) {
        this._configuration = configuration;
    }

    @PostConstruct
    public void completeInitialization() {
        if (this._configuration == null) {
            this._log.warn("No token manager configuration provided for {}: using defaults...", (Object)this);
            this._configuration = new TokenManagerSimpleConfiguration(TOKEN_CACHE_ID, 10000, 5);
        }
        this._cacheManager = CacheManager.getInstance();
        if (this._cacheManager == null) {
            this._cacheManager = CacheManager.create();
        }
        String cacheId = this._configuration.getTokenCacheId();
        this._log.info("Initializing {} with {} and cache ID {}", new Object[]{this, this._cacheManager, cacheId});
        if (!this._cacheManager.cacheExists(cacheId)) {
            CacheConfiguration cacheConfiguration = new CacheConfiguration(cacheId, this._configuration.getTokenCacheSize());
            cacheConfiguration.eternal(false).timeToIdleSeconds((long)this._configuration.getTokenExpirationTime()).timeToLiveSeconds((long)this._configuration.getTokenExpirationTime()).memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.FIFO).overflowToOffHeap(false);
            this._tokenCache = new Cache(cacheConfiguration);
            this._tokenCache.getCacheEventNotificationService().registerListener((CacheEventListener)this);
            this._cacheManager.addCacheIfAbsent((Ehcache)this._tokenCache);
        }
        this._log.info("{} has been initialized with {}", this.getClass(), this._configuration.getClass());
    }

    public void updateCacheTimeout(int timeout) {
        this._tokenCache.getCacheConfiguration().setTimeToIdleSeconds((long)timeout);
    }

    public Cache getCache() {
        return this._tokenCache;
    }

    @Override
    public boolean exists(String token) {
        return this._tokenCache.get((Serializable)((Object)token)) != null && this._tokenCache.isKeyInCache((Object)token);
    }

    @Override
    public void store(String token) {
        this._tokenCache.put(new Element((Serializable)((Object)token), (Serializable)Long.valueOf(System.currentTimeMillis())));
    }

    @Override
    public boolean remove(String token) {
        return this._tokenCache.remove((Serializable)((Object)token));
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        this._log.info("Element {} has been evicted from cache {}", element.getObjectKey(), (Object)cache.getName());
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        this._log.info("Element {} of cache {} has expired", element.getObjectKey(), (Object)cache.getName());
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        this._log.info("Putting element {} in cache {}", element.getObjectKey(), (Object)cache.getName());
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        this._log.warn("Element {} of cache {} has been removed", element.getObjectKey(), (Object)cache.getName());
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        this._log.warn("Element {} of cache {} has been updated", element.getObjectKey(), (Object)cache.getName());
    }

    public void notifyRemoveAll(Ehcache cache) {
        this._log.warn("Removing all elements from cache {}", (Object)cache.getName());
    }

    public void dispose() {
        this._log.warn("Disposing caches...");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._cacheManager.shutdown();
    }

    protected String getScopedToken(String scope, String token) {
        return scope + "_" + token;
    }
}

