/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.server.javax.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.decryption.DecryptionService;
import org.fao.fi.security.common.support.decryption.EncryptedInputStreamWrapper;
import org.fao.fi.security.common.utilities.LoggingClient;
import org.fao.fi.security.server.javax.interceptors.support.encryption.EncryptedInputResource;

@Provider
@Consumes(value={"*/*"})
@EncryptedInputResource
public class EncryptedResourceReaderInterceptor
extends LoggingClient
implements ReaderInterceptor {
    @Inject
    private DecryptionService _decryptor;

    public EncryptedResourceReaderInterceptor() {
    }

    public EncryptedResourceReaderInterceptor(DecryptionService decryptor) {
        this._decryptor = decryptor;
    }

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.setInputStream((InputStream)new EncryptedInputStreamWrapper(context.getInputStream(), this._decryptor));
            return context.proceed();
        }
        catch (GeneralSecurityException se) {
            this._log.error(se.getMessage(), (Throwable)se);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-SECURED-WITH", (Object)"ENCRYPTED-INPUT-STREAM").entity((Object)"You are not authorized to access this resource").build());
        }
        catch (KeyringException kre) {
            this._log.error(kre.getMessage(), (Throwable)kre);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-SECURED-WITH", (Object)"ENCRYPTED-INPUT-STREAM").entity((Object)"You are not authorized to access this resource").build());
        }
        catch (Throwable IOe) {
            this._log.error(IOe.getMessage(), IOe);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-SECURED-WITH", (Object)"ENCRYPTED-INPUT-STREAM").entity((Object)"You are not authorized to access this resource").build());
        }
    }
}

