/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.server.javax.interceptors;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.encryption.EncryptionService;
import org.fao.fi.security.common.support.encryption.EncryptedOutputStreamWrapper;
import org.fao.fi.security.common.utilities.LoggingClient;
import org.fao.fi.security.server.javax.interceptors.support.encryption.EncryptedOutputResource;

@EncryptedOutputResource
public class EncryptedResourceWriterInterceptor
extends LoggingClient
implements WriterInterceptor {
    @Inject
    @Singleton
    private EncryptionService _encryptor;

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.setOutputStream((OutputStream)new EncryptedOutputStreamWrapper(context.getOutputStream(), this._encryptor));
            context.proceed();
        }
        catch (IOException IOe) {
            this._log.error(IOe.getMessage(), (Throwable)IOe);
            Throwable cause = IOe.getCause();
            if (cause != null && (KeyringException.class.isAssignableFrom(cause.getClass()) || GeneralSecurityException.class.isAssignableFrom(cause.getClass()))) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-SECURED-WITH", (Object)"ENCRYPTED-OUTPUT-STREAM").entity((Object)"You are not authorized to access this resource").build());
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-SECURED-WITH", (Object)"ENCRYPTED-OUTPUT-STREAM").entity((Object)"You are not authorized to access this resource").build());
        }
    }
}

