/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.server.javax.filters.origin;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.fao.fi.security.server.javax.filters.AbstractRequestValidatorFilter;
import org.fao.fi.security.server.javax.filters.origin.configuration.RestrictedIPsConfiguration;
import org.fao.fi.security.server.javax.filters.origin.support.IPRestrictedResource;
import org.fao.fi.security.server.javax.filters.origin.support.IPRestrictor;

@IPRestrictedResource
@Priority(value=1000)
public class IPRestrictedResourceRequestValidatorFilter
extends AbstractRequestValidatorFilter {
    @Context
    private HttpServletRequest _servletRequest;
    private RestrictedIPsConfiguration _configuration;
    private Pattern _validationPattern;

    @Inject
    public IPRestrictedResourceRequestValidatorFilter(@IPRestrictor RestrictedIPsConfiguration configuration) {
        this._configuration = configuration;
    }

    @PostConstruct
    private void completeInitialization() {
        String $THIS = ((Object)((Object)this)).getClass().getSimpleName() + "#" + ((Object)((Object)this)).hashCode();
        this._log.info("{} has been initialized with {}", (Object)$THIS, (Object)this._configuration);
        this._validationPattern = this._configuration.getValidationPattern();
    }

    @Override
    protected String getSecurityScheme() {
        return "SOURCE-IP-FILTER";
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            String host = this._servletRequest.getRemoteHost();
            String xff = requestContext.getHeaderString("X-FORWARDED-FOR");
            this._log.debug("Intercepted a {} request for {} coming from host {} [ XFF: {} ]", new Object[]{requestContext.getMethod(), requestContext.getUriInfo().getAbsolutePath(), host, xff == null ? "NOT SET" : xff});
            boolean allow = this._validationPattern.matcher(host).matches();
            if (xff != null) {
                allow &= this._validationPattern.matcher(xff).matches();
            }
            if (!allow) {
                requestContext.abortWith(this.errorResponse(Response.Status.FORBIDDEN, "You are not authorized to access this resource"));
                this._log.warn("Blocked a {} request for {} coming from host {} [ XFF: {} ]", new Object[]{requestContext.getMethod(), requestContext.getUriInfo().getAbsolutePath(), host, xff == null ? "NOT SET" : xff});
            }
        }
        catch (Throwable t) {
            this._log.error("Unexpected {} caught: {}", new Object[]{t.getClass(), t.getMessage(), t});
            requestContext.abortWith(this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, t.getMessage()));
        }
    }
}

