/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.services.providers.validators.token.impl;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import org.fao.fi.security.common.services.exceptions.UnauthorizedRequestException;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.services.exceptions.token.TokenProductionException;
import org.fao.fi.security.common.services.spi.token.TokenProducerService;
import org.fao.fi.security.common.utilities.LoggingClient;
import org.fao.fi.security.server.providers.validators.token.spi.TokenProducer;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
@Path("/token") 
abstract public class AbstractTokenProducerServiceImpl extends LoggingClient implements TokenProducerService {
	protected TokenProducer _producer;
	
	/**
	 * Class constructor
	 *
	 * @param producer
	 */
	public AbstractTokenProducerServiceImpl(TokenProducer producer) {
		super();
		this._producer = producer;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.common.services.spi.token.TokenProducerService#requestToken()
	 */
	@Override
	@GET @Path("request") @Produces("text/plain")
	public String requestToken() throws TokenProductionException, TokenProcessingException, UnauthorizedRequestException {
		return this._producer.process(this._producer.createNewToken());
	}
}
