/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.providers.validators.token.spi;

import java.net.InetAddress;

import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.services.exceptions.token.TokenProductionException;
import org.fao.fi.security.common.support.token.spi.TokenProcessor;
import org.fao.fi.security.common.utilities.EncryptionUtils;
import org.fao.fi.security.common.utilities.LoggingClient;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 29 Apr 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 29 Apr 2014
 */
abstract public class AbstractTokenProducer extends LoggingClient implements TokenProducer {
	private TokenManager _tokenManager;
	private TokenProcessor _tokenProcessor;
	
	public AbstractTokenProducer(TokenManager tokenManager, TokenProcessor tokenProcessor) {
		this._tokenManager = tokenManager;
		this._tokenProcessor = tokenProcessor;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.providers.token.spi.TokenProducer#createNewToken()
	 */
	@Override
	public synchronized String createNewToken() throws TokenProductionException {
		try {
			boolean isValid = false;
	
			long now, nanos;
			now = nanos = -1;
			
			StringBuilder plainToken;
			String token = null, localhostIP = InetAddress.getLocalHost().getHostAddress();
			
			while(!isValid) {
				plainToken = new StringBuilder();
				
				now = System.currentTimeMillis();
				nanos = System.nanoTime();
							
				plainToken.append(now).append("|").append(nanos).append("|").append(localhostIP);
						
				token = EncryptionUtils.getMD5Sum(plainToken.toString());
				
				if(this._tokenManager.exists(token)) {
					this._log.warn("Collision detected for token {} ( generated by {}|{}|{} )", token, now, nanos, localhostIP);
				} else {
					this._tokenManager.store(token);
					
					isValid = true;
				}
			}
			
			return token;
		} catch (Throwable t) {
			throw new TokenProductionException(t.getMessage(), t);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.providers.token.spi.TokenProducer#process(java.lang.String)
	 */
	@Override
	public String process(String token) throws TokenProcessingException {
		return this._tokenProcessor.processAfterCreation(token);
	}
}