/**
 * (c) 2014 FAO / UN (project: fi-security-client)
 */
package org.fao.fi.security.server.javax.interceptors;

import java.io.IOException;
import java.security.GeneralSecurityException;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;

import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.decryption.DecryptionService;
import org.fao.fi.security.common.support.decryption.EncryptedInputStreamWrapper;
import org.fao.fi.security.common.utilities.LoggingClient;
import org.fao.fi.security.server.javax.filters.FilterConstants;
import org.fao.fi.security.server.javax.filters.encryption.support.EncryptionConstants;
import org.fao.fi.security.server.javax.interceptors.support.encryption.EncryptedInputResource;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
@EncryptedInputResource
public class EncryptedResourceReaderInterceptor extends LoggingClient implements ReaderInterceptor {
	@Inject private @Singleton DecryptionService _decryptor;

	/**
	 * Class constructor
	 */
	public EncryptedResourceReaderInterceptor() {
	}
	
	/**
	 * Class constructor
	 *
	 * @param decryptor
	 */
	public EncryptedResourceReaderInterceptor(DecryptionService decryptor) {
		super();
		this._decryptor = decryptor;
	}

	/* (non-Javadoc)
	 * @see javax.ws.rs.ext.ReaderInterceptor#aroundReadFrom(javax.ws.rs.ext.ReaderInterceptorContext)
	 */
	@Override
	public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
		try {
			context.setInputStream(new EncryptedInputStreamWrapper(context.getInputStream(), this._decryptor));
			
			return context.proceed();
		} catch(GeneralSecurityException|KeyringException se) {
			this._log.error(se.getMessage(), se);
			
			throw new WebApplicationException(Response.status(Response.Status.BAD_REQUEST).header(FilterConstants.SECURED_WITH_HEADER, EncryptionConstants.ENCRYPTED_INPUT_STREAM_SECURITY_TYPE_HEADER).entity("You are not authorized to access this resource").build());
		} catch(Throwable IOe) {
			this._log.error(IOe.getMessage(), IOe);
			
			throw new WebApplicationException(Response.status(Response.Status.INTERNAL_SERVER_ERROR).header(FilterConstants.SECURED_WITH_HEADER, EncryptionConstants.ENCRYPTED_INPUT_STREAM_SECURITY_TYPE_HEADER).entity("You are not authorized to access this resource").build());
		}
	}
}
