/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.javax.filters.token;

import org.fao.fi.security.server.javax.filters.token.support.EncryptedTokenConstants;
import org.fao.fi.security.server.providers.validators.SecuredResourceValidationServiceProvider;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 30 Apr 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 30 Apr 2014
 */
abstract public class EncryptedTokenSecuredResourceRequestValidatorFilter extends AbstractTokenSecuredResourceRequestValidatorFilter {
	/**
	 * Class constructor
	 *
	 * @param validator
	 */
	public EncryptedTokenSecuredResourceRequestValidatorFilter(SecuredResourceValidationServiceProvider validator) {
		super(validator);
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.token.AbstractTokenSecuredResourceRequestValidatorFilter#getSecurityScheme()
	 */
	@Override
	final protected String getSecurityScheme() {
		return EncryptedTokenConstants.ENCRYPTED_TOKEN_SECURITY_TYPE_HEADER;
	}
}