/**
 * (c) 2014 FAO / UN (project: fi-security-integration)
 */
package org.fao.fi.security.integration.test.support.server.token.plain;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import org.fao.fi.security.common.services.exceptions.UnauthorizedRequestException;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.services.exceptions.token.TokenProductionException;
import org.fao.fi.security.server.javax.filters.bandwidth.support.BandwidthLimitedResource;
import org.fao.fi.security.server.javax.filters.origin.support.IPRestrictedResource;
import org.fao.fi.security.server.providers.validators.token.impl.plain.PlainTokenProducer;
import org.fao.fi.security.server.services.providers.validators.token.impl.LocalTokenProducerServiceImpl;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 5 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 5 May 2014
 */
@Singleton @IPRestrictedResource@Path("/token/plain")
public class PlainTokenProducerTestServiceImpl extends LocalTokenProducerServiceImpl {
	/**
	 * Class constructor
	 */
	@Inject public PlainTokenProducerTestServiceImpl(PlainTokenProducer tokenProducer) throws NamingException {
		super(tokenProducer);
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.common.services.spi.token.TokenProducerService#requestToken()
	 */
	@Override
	@GET @Path("request") @Produces("text/plain")
	public String requestToken() throws TokenProductionException, TokenProcessingException, UnauthorizedRequestException {
		return super.requestToken();
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.common.services.spi.token.TokenProducerService#requestToken()
	 */
	@GET @Path("request/limited") @Produces("text/plain")
	@BandwidthLimitedResource public String bandwidthLimitedRequestToken() throws TokenProductionException, TokenProcessingException, UnauthorizedRequestException {
		return super.requestToken();
	}	 
}