/**
 * (c) 2014 FAO / UN (project: fi-security-common)
 */
package org.fao.fi.security.common.support.configuration;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 3 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 3 May 2014
 */
abstract public class AbstractJNDIConfiguration implements Configuration {
	protected Logger _log = LoggerFactory.getLogger(this.getClass());

	protected Context _initialContext;
	protected Context _envContext;
	
	public AbstractJNDIConfiguration() throws NamingException {
		this._initialContext = new InitialContext();
		this._envContext = (Context)this._initialContext.lookup("java:comp/env/");
	}
	
	@SuppressWarnings("unchecked")
	protected <R> R getEnvResource(String resourceName) {
		try {
			return (R)this._envContext.lookup(resourceName);
		} catch(NamingException Ne) {
			this._log.warn("Unable to access JNDI resource at {}: {} [ {} ]", resourceName, Ne.getClass().getName(), Ne.getMessage(), Ne);
			throw new IllegalArgumentException("Unable to access JNDI resource at " + resourceName, Ne);
		} catch(Exception e) {
			this._log.warn("Unexpected error while attempting to access JNDI resource at {}: {} [ {} ]", resourceName, e.getClass().getName(), e.getMessage(), e);
			throw new IllegalArgumentException("Unexpected error while attempting to access JNDI resource at " + resourceName, e);			
		}
	}
}