/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.common.support.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.encryption.EncryptionService;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
public class EncryptedOutputStreamWrapper extends ByteArrayOutputStream {
	private OutputStream _wrapped;
	private EncryptionService _streamEncryptor;
		
	/**
	 * Class constructor
	 *
	 * @param wrapped
	 * @param streamEncryptor
	 */
	public EncryptedOutputStreamWrapper(OutputStream wrapped, EncryptionService streamEncryptor) {
		super();
		this._wrapped = wrapped;
		this._streamEncryptor = streamEncryptor;
	}

	/* (non-Javadoc)
	 * @see java.io.ByteArrayOutputStream#close()
	 */
	@Override
	public void close() throws IOException {
		this.flush();
		
		ByteArrayInputStream bufferedBytes = new ByteArrayInputStream(this.toByteArray());
		
		try {
			this._streamEncryptor.encrypt(bufferedBytes, this._wrapped);
		} catch(KeyringException e) {
			throw new IOException(e);
		} catch(GeneralSecurityException e) {
			throw new IOException(e);
		}
		
		bufferedBytes.close();
		
		super.close();
	}
}
