/**
 * (c) 2014 FAO / UN (project: fi-security-client)
 */
package org.fao.fi.security.client.javax.filters;

import java.io.IOException;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

import org.fao.fi.security.common.services.spi.encryption.EncryptionService;
import org.fao.fi.security.common.support.encryption.EncryptedOutputStreamWrapper;
import org.fao.fi.security.common.utilities.LoggingClient;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
public class EncryptedRequestDecorator extends LoggingClient implements ClientRequestFilter {
	@Inject private @Singleton EncryptionService _encryptor;

	/**
	 * Class constructor
	 *
	 * @param encryptor
	 */
	public EncryptedRequestDecorator(EncryptionService encryptor) {
		super();
		
		this._encryptor = encryptor;
	}

	/* (non-Javadoc)
	 * @see javax.ws.rs.client.ClientRequestFilter#filter(javax.ws.rs.client.ClientRequestContext)
	 */
	@Override
	public void filter(ClientRequestContext requestContext) throws IOException {
		requestContext.setEntityStream(new EncryptedOutputStreamWrapper(requestContext.getEntityStream(), this._encryptor));
	}
}
