/**
 * 
 */
package org.cotrix.web.importwizard.server.climport;

import java.util.List;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Singleton;

import org.cotrix.action.events.CodelistActionEvents;
import org.cotrix.action.events.CodelistActionEvents.Import;
import org.cotrix.common.Outcome;
import org.cotrix.common.Report;
import org.cotrix.common.cdi.BeanSession;
import org.cotrix.common.tx.Transactional;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.web.importwizard.server.climport.ImporterSource.SourceParameterProvider;
import org.cotrix.web.share.server.util.Reports;
import org.cotrix.web.share.shared.Progress;
import org.cotrix.web.share.shared.Progress.Status;
import org.cotrix.web.share.shared.ReportLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author "Federico De Faveri federico.defaveri@fao.org"
 *
 */
@Singleton
public class Importer {

	protected Logger logger = LoggerFactory.getLogger(Importer.class);
	
	@Inject
	private Event<CodelistActionEvents.Import> events;

	@Transactional
	public <T> void importCodelist(Progress progress, SourceParameterProvider<T> sourceParameterProvider,
			ImporterSource source,
			ImporterMapper<T> mapper,
			ImporterTarget target,
			ImportTaskSession session,
			BeanSession beanSession) {
		
		logger.trace("starting import");
		try {
			progress.setStatus(Status.ONGOING);

			logger.trace("retrieving code list");
			T data = source.getCodelist(session, sourceParameterProvider);

			logger.trace("mapping codelist");
			Outcome<Codelist> outcome = mapper.map(session, data);

			Report report = outcome.report();
			logger.trace("is failed? {}", report.isFailure());
			//logger.trace("Report: {}", report.toString());

			logger.trace("found {} logs item", report.logs().size());
			List<ReportLog> logs = Reports.convertLogs(report.logs());
			session.setLogs(logs);
			session.setReport(report.toString());

			if (report.isFailure()) {
				logger.error("Import failed");
				progress.setStatus(Status.FAILED);
				return;
			}

			logger.trace("adding codelist");
			Codelist codelist = outcome.result();
			target.save(codelist, session.getMetadata().isSealed(), session.getOwnerId());

			progress.setStatus(Status.DONE);
			
			events.fire(new Import(codelist.id(), codelist.name(), codelist.version(), beanSession));

		} catch(Throwable throwable)
		{
			logger.error("Error during import", throwable);
			progress.setStatus(Status.FAILED);
			session.setLogs(Reports.convertLogs(throwable));
			session.setReport(throwable.getMessage());
		}
	}

	

}
