/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import javax.xml.namespace.QName;
import org.acme.DomainTest;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.memory.MNamed;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.DomainConstants;
import org.junit.Assert;
import org.junit.Test;

public class NamedTest
extends DomainTest {
    @Test
    public void namesMustBeValid() {
        MNamed state = new MNamed();
        try {
            state.qname(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            state.qname(Data.q((String)""));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void namesCannotBeErased() {
        Named.Private e = this.like(new MyEntity(new MNamed()));
        MNamed mychange = new MNamed(e.id(), Status.MODIFIED);
        mychange.qname(DomainConstants.NULL_QNAME);
        MyEntity changeset = new MyEntity(mychange);
        try {
            e.update((Named.Private)changeset);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void namesCanBeChanged() {
        Named.Private e = this.like(new MyEntity(new MNamed()));
        MNamed mychange = new MNamed(e.id(), Status.MODIFIED);
        mychange.qname(new QName("newname"));
        MyEntity changeset = new MyEntity(mychange);
        e.update((Named.Private)changeset);
        Assert.assertEquals((Object)new QName("newname"), (Object)e.qname());
    }

    static class MyEntity
    extends Named.Private<MyEntity, MNamed> {
        public MyEntity(MNamed state) {
            super((Named.Bean)state);
        }
    }
}

