/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import java.util.Arrays;
import java.util.Iterator;
import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.common.Utils;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.common.NamedContainer;
import org.cotrix.domain.common.NamedStateContainer;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.trait.Identified;
import org.junit.Assert;
import org.junit.Test;

public class ContainerTest
extends DomainTest {
    @Test
    public void beansMustBeValid() {
        try {
            new Container.Private(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void beansArePreserved() {
        Attribute a1 = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        Attribute a2 = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name2)).build();
        NamedStateContainer<Attribute.State> beans = this.likes(a1, a2);
        Container.Private c = Codes.container(beans);
        Assert.assertEquals((long)2L, (long)c.size());
        Assert.assertEquals(beans, (Object)c.state());
    }

    @Test
    public void beansAreWrapped() {
        Attribute a1 = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        Attribute a2 = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name2)).build();
        Container.Private c = Codes.container(this.likes(a1, a2));
        Assert.assertTrue((boolean)c.contains((Object)a1));
        Assert.assertTrue((boolean)c.contains((Object)a2));
        Iterator it = c.iterator();
        Assert.assertEquals((Object)a1, it.next());
        Assert.assertEquals((Object)a2, it.next());
    }

    @Test
    public void namedEntitiesAreHandled() {
        Attribute a1 = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name("a")).build();
        Attribute a2 = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name("b")).build();
        Attribute a3 = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name("b")).build();
        NamedContainer.Private c = Codes.namedContainer(this.likes(a1, a2, a3));
        Assert.assertTrue((boolean)c.contains(Codes.q((String)"a")));
        Assert.assertFalse((boolean)c.contains(Codes.q((String)"c")));
        Assert.assertEquals(Arrays.asList(a1), (Object)c.getAll(Codes.q((String)"a")));
        Assert.assertEquals((Object)a1, (Object)c.lookup(Codes.q((String)"a")));
        Assert.assertEquals(Arrays.asList(a2, a3), (Object)c.getAll(Codes.q((String)"b")));
        try {
            c.lookup(Codes.q((String)"b"));
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    @Test
    public void entitiesCanBeAdded() {
        Container.Private c = Codes.container((Identified.State[])new Object[0]);
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        Container.Private changeset = Codes.container(this.likes(a));
        c.update((Container.Abstract)changeset);
        Assert.assertEquals((long)1L, (long)c.size());
        Assert.assertTrue((boolean)c.contains((Object)a));
    }

    @Test
    public void entitiesCanBeRemoved() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        Container.Private c = Codes.container(this.likes(a));
        Attribute deleted = Codes.deleteAttribute((String)a.id());
        Container.Private changeset = Codes.container((Identified.State[])new Attribute.State[]{(Attribute.State)((Attribute.Private)Utils.reveal((Object)deleted, Attribute.Private.class)).state()});
        c.update((Container.Abstract)changeset);
        Assert.assertEquals((long)0L, (long)c.size());
        Assert.assertFalse((boolean)c.contains((Object)a.name()));
    }

    @Test
    public void entitiesCanBeModified() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name(Fixture.name)).build();
        NamedStateContainer<Attribute.State> sc = this.likes(a);
        Container.Private c = Codes.container(sc);
        Attribute modified = (Attribute)((AttributeGrammar.ValueClause)Codes.modifyAttribute((String)a.id()).name(Fixture.name2)).build();
        Container.Private changeset = Codes.container((Identified.State[])new Attribute.State[]{this.stateOf(modified)});
        c.update((Container.Abstract)changeset);
        Assert.assertEquals((long)1L, (long)c.size());
        Assert.assertTrue((boolean)sc.contains(modified.name()));
    }

    private Attribute.State stateOf(Attribute a) {
        return (Attribute.State)((Attribute.Private)Utils.reveal((Object)a, Attribute.Private.class)).state();
    }
}

