/*
 * Decompiled with CFR 0.152.
 */
package org.acme.users;

import java.util.Collection;
import org.acme.DomainTest;
import org.cotrix.action.Action;
import org.cotrix.action.Actions;
import org.cotrix.action.ResourceType;
import org.cotrix.common.Utils;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.UserGrammar;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.junit.Assert;
import org.junit.Test;

public class RoleTest
extends DomainTest {
    Action doit = Actions.action((ResourceType)ResourceType.application, (String)"doit", (String[])new String[0]);
    Action dothat = Actions.action((ResourceType)ResourceType.application, (String)"dothat", (String[])new String[0]);
    Action dothatToo = Actions.action((ResourceType)ResourceType.application, (String)"dothatToo", (String[])new String[0]);

    @Test
    public void assignTemplateRole() {
        Role something = Roles.role((String)"r1").buildAsRoleFor(ResourceType.application);
        Role somethingElse = Roles.role((String)"r2").buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{something, somethingElse}).build());
        Assert.assertTrue((boolean)bill.is(something));
        Assert.assertTrue((boolean)bill.is(somethingElse));
        Utils.assertEqualUnordered((Collection)bill.directRoles(), (Object[])new Object[]{something, somethingElse});
        Utils.assertEqualUnordered((Collection)bill.roles(), (Object[])new Object[]{something, somethingElse});
    }

    @Test
    public void revokeTemplateRole() {
        Role something = Roles.role((String)"r1").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role somethingElse = Roles.role((String)"r2").can(new Action[]{this.dothat}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{something, somethingElse}).build());
        User changeset = Users.modifyUser((User)bill).isNoLonger(new Role[]{something}).build();
        this.update(bill, changeset);
        Assert.assertFalse((boolean)bill.is(something));
        Assert.assertTrue((boolean)bill.is(somethingElse));
        Utils.assertEqualUnordered((Collection)bill.directRoles(), (Object[])new Object[]{somethingElse});
        Utils.assertEqualUnordered((Collection)bill.roles(), (Object[])new Object[]{somethingElse});
    }

    @Test
    public void rolesHaveIdentity() {
        Role something = this.aRole().can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().can(new Action[]{this.doit}).build());
        Assert.assertFalse((boolean)bill.is(something));
    }

    @Test
    public void assigningRolesGivesPermissions() {
        Role something = this.aRole().can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{something}).build());
        Assert.assertTrue((boolean)bill.can(this.doit));
    }

    @Test
    public void revokingRolesRemovesPermissions() {
        Role something = this.aRole().can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{something}).build());
        System.out.println(bill);
        Assert.assertTrue((boolean)bill.can(this.doit));
        System.out.println(bill);
        User changeset = Users.modifyUser((User)bill).isNoLonger(new Role[]{something}).build();
        System.out.println(bill);
        this.update(bill, changeset);
        System.out.println(bill);
        Assert.assertFalse((boolean)bill.can(this.doit));
    }

    @Test
    public void assignInstanceRoles() {
        Role something = this.aRole().can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{something.on("1")}).build());
        Assert.assertFalse((boolean)bill.can(this.doit));
        Assert.assertTrue((boolean)bill.can(this.doit.on("1")));
    }

    @Test
    public void revokeInstanceRole() {
        Role something = this.aRole().can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{something.on("1")}).build());
        Assert.assertTrue((boolean)bill.is(something.on("1")));
        User changeset = Users.modifyUser((User)bill).isNoLonger(new Role[]{something.on("1")}).build();
        this.update(bill, changeset);
        Assert.assertFalse((boolean)bill.is(something.on("1")));
    }

    @Test
    public void permissionsCanBeDirectOrIndirect() {
        Role something = this.aRole().can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{something}).can(new Action[]{this.dothat}).build());
        Utils.assertEqualUnordered((Collection)bill.directPermissions(), (Object[])new Object[]{this.dothat});
        Utils.assertEqualUnordered((Collection)bill.permissions(), (Object[])new Object[]{this.doit, this.dothat});
    }

    @Test
    public void rolesCompose() {
        Role small = Roles.role((String)"r1").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role larger = Roles.role((String)"r2").can(new Action[]{this.dothat}).is(new Role[]{small}).buildAsRoleFor(ResourceType.application);
        Role largerStill = Roles.role((String)"r3").can(new Action[]{this.dothatToo}).is(new Role[]{larger}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{largerStill}).build());
        Utils.assertEqualUnordered((Collection)bill.roles(), (Object[])new Object[]{small, larger, largerStill});
        Utils.assertEqualUnordered((Collection)bill.directRoles(), (Object[])new Object[]{largerStill});
        Assert.assertTrue((boolean)bill.is(small));
        Assert.assertTrue((boolean)bill.is(larger));
        Assert.assertTrue((boolean)bill.is(largerStill));
        Assert.assertTrue((boolean)bill.isDirectly(largerStill));
        Assert.assertFalse((boolean)bill.isDirectly(larger));
        Assert.assertFalse((boolean)bill.isDirectly(small));
        Assert.assertTrue((boolean)bill.can(this.doit));
        Assert.assertTrue((boolean)bill.can(this.dothat));
        Assert.assertTrue((boolean)bill.can(this.dothatToo));
    }

    @Test
    public void smallerRolesAreNotAdded() {
        Role something = Roles.role((String)"r1").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role somethingElse = Roles.role((String)"r2").can(new Action[]{this.dothat}).is(new Role[]{something}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{somethingElse}).build());
        System.out.println("UPDATING");
        User changeset = Users.modifyUser((User)bill).is(new Role[]{something}).build();
        this.update(bill, changeset);
        Utils.assertEqualUnordered((Collection)bill.directRoles(), (Object[])new Object[]{somethingElse});
    }

    @Test
    public void largerRolesReplaceSmallerOnes() {
        Role small = Roles.role((String)"r1").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role large = Roles.role((String)"r2").can(new Action[]{this.dothat}).is(new Role[]{small}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{large}).build());
        Role largerStill = Roles.role((String)"r3").can(new Action[]{this.dothatToo}).is(new Role[]{large}).buildAsRoleFor(ResourceType.application);
        User changeset = Users.modifyUser((User)bill).is(new Role[]{largerStill}).build();
        this.update(bill, changeset);
        Utils.assertEqualUnordered((Collection)bill.directRoles(), (Object[])new Object[]{largerStill});
    }

    @Test
    public void revokeRoleFromHierarchy() {
        Role something = Roles.role((String)"something").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role somethingElse = Roles.role((String)"somethingElse").can(new Action[]{this.dothat}).is(new Role[]{something}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{somethingElse}).build());
        User changeset = Users.modifyUser((User)bill).isNoLonger(new Role[]{something}).build();
        this.update(bill, changeset);
        Assert.assertTrue((boolean)bill.is(something));
    }

    @Test
    public void roleHierarchiesFollowInstantiation() {
        Role something = Roles.role((String)"role1").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.codelists);
        Role somethingElse = Roles.role((String)"role2").can(new Action[]{this.dothat}).is(new Role[]{something}).buildAsRoleFor(ResourceType.codelists);
        Role somethingElseStill = Roles.role((String)"role3").can(new Action[]{this.dothatToo}).is(new Role[]{somethingElse}).buildAsRoleFor(ResourceType.codelists);
        User bill = this.like(this.bill().is(new Role[]{somethingElseStill.on("1")}).build());
        Utils.assertEqualUnordered((Collection)bill.roles(), (Object[])new Object[]{something.on("1"), somethingElse.on("1"), somethingElseStill.on("1")});
        Assert.assertTrue((boolean)bill.is(something.on("1")));
        Assert.assertTrue((boolean)bill.is(somethingElse.on("1")));
        Assert.assertTrue((boolean)bill.is(somethingElseStill.on("1")));
        Assert.assertTrue((boolean)bill.can(this.doit.on("1")));
        Assert.assertTrue((boolean)bill.can(this.dothat.on("1")));
        Assert.assertTrue((boolean)bill.can(this.dothatToo.on("1")));
    }

    @Test
    public void rolesAndPermissionsCanOverlap() {
        Role someone = this.aRole().can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{someone}).can(new Action[]{this.doit}).build());
        Utils.assertEqualUnordered((Collection)bill.permissions(), (Object[])new Object[]{this.doit});
    }

    @Test
    public void rolesCanOverlap() {
        Role someone = Roles.role((String)"r1").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        Role someoneElse = Roles.role((String)"r2").can(new Action[]{this.doit}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{someone, someoneElse}).build());
        Assert.assertTrue((boolean)bill.is(someone));
        Assert.assertTrue((boolean)bill.is(someoneElse));
        Utils.assertEqualUnordered((Collection)bill.permissions(), (Object[])new Object[]{this.doit});
    }

    @Test
    public void rolesAreNotAddedTwice() {
        Role someone = this.aRole().buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{someone, someone}).build());
        Utils.assertEqualUnordered((Collection)bill.roles(), (Object[])new Object[]{someone});
    }

    @Test
    public void rolesCanBeReplaced() {
        Role someone = Roles.role((String)"r1").buildAsRoleFor(ResourceType.application);
        Role someoneElse = Roles.role((String)"r2").is(new Role[]{someone}).buildAsRoleFor(ResourceType.application);
        User bill = this.like(this.bill().is(new Role[]{someoneElse}).build());
        User changeset = Users.modifyUser((User)bill).isNoLonger(bill.directRoles()).is(new Role[]{someone}).build();
        this.update(bill, changeset);
        Utils.assertEqualUnordered((Collection)bill.directRoles(), (Object[])new Object[]{someone});
    }

    private User.Private reveal(User u) {
        return (User.Private)Utils.reveal((Object)u, User.Private.class);
    }

    private void update(User u, User changeset) {
        this.reveal(u).update(this.reveal(changeset));
    }

    private UserGrammar.ThirdClause bill() {
        return Users.user().name("bill").fullName("bill").noMail();
    }

    private UserGrammar.ThirdClause aRole() {
        return Roles.role((String)"role");
    }
}

